/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.logging;

import com.google.common.eventbus.Subscribe;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.events.ActorAsksQuestion;
import net.serenitybdd.screenplay.events.ActorBeginsPerformanceEvent;
import net.serenitybdd.screenplay.events.ActorEndsPerformanceEvent;
import net.serenitybdd.screenplay.events.ActorPerforms;
import net.thucydides.core.steps.ReplaceField;
import net.thucydides.core.steps.StepName;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformableLogger {
    int level = 0;
    String currentActor;
    private static final String ANSI_GREEN = "\u001b[32m";
    private static final String ANSI_RESET = "\u001b[0m";
    private Logger logger = LoggerFactory.getLogger((String)"screenplay");

    @Subscribe
    public void beginPerformance(ActorBeginsPerformanceEvent performanceEvent) {
        this.currentActor = performanceEvent.getName();
        ++this.level;
    }

    @Subscribe
    public void endPerformance(ActorEndsPerformanceEvent performanceEvent) {
        --this.level;
    }

    @Subscribe
    public void perform(ActorPerforms performAction) {
        String stepTitle = "";
        stepTitle = this.isInstrumented(performAction.getPerformable()) ? this.titleFromParentOf(performAction.getPerformable()).replace("{0}", this.currentActor) : performAction.getPerformable().toString().replace("{0}", this.currentActor);
        this.logger.info(ANSI_GREEN + this.indentation(this.level) + " " + stepTitle + ANSI_RESET);
    }

    private String indentation(int level) {
        return "|" + StringUtils.repeat((String)"-", (int)(level * 2));
    }

    private String titleFromParentOf(Performable performable) {
        try {
            Method performAs = performable.getClass().getSuperclass().getMethod("performAs", Actor.class);
            Optional stepName = StepName.fromStepAnnotationIn((Method)performAs);
            if (stepName.isPresent()) {
                Map<String, Object> fields = this.fieldValuesIn(performable);
                return this.replaceFieldTokensWithFieldValuesIn((String)stepName.get(), fields);
            }
            return performable.getClass().getSuperclass().getName();
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return performable.getClass().getSuperclass().getName();
        }
    }

    private Map<String, Object> fieldValuesIn(Performable performable) throws IllegalAccessException {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        for (Field field : this.allFieldsIn(performable.getClass())) {
            field.setAccessible(true);
            fieldValues.put(field.getName(), "" + field.get(performable));
        }
        return fieldValues;
    }

    private List<Field> allFieldsIn(Class<?> someClass) {
        return PerformableLogger.getFields(someClass);
    }

    private String replaceFieldTokensWithFieldValuesIn(String description, Map<String, Object> fields) {
        for (String field : fields.keySet()) {
            description = ReplaceField.in((String)description).theFieldCalled(field).with(fields.get(field));
        }
        return description;
    }

    public static List<Field> getFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> classToInspect = clazz; classToInspect != null; classToInspect = classToInspect.getSuperclass()) {
            fields.addAll(Arrays.asList(classToInspect.getDeclaredFields()));
        }
        return fields;
    }

    private boolean isInstrumented(Performable performable) {
        return performable.toString().contains("$ByteBuddy");
    }

    @Subscribe
    public void prepareQuestion(ActorAsksQuestion questionEvent) {
        System.out.println("Question " + questionEvent.getQuestion());
    }
}

