/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.waits;

import java.time.Duration;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.EventualConsequence;
import net.serenitybdd.screenplay.GivenWhenThen;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.waits.WaitWithTimeout;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import org.hamcrest.Matcher;

public class WaitOnQuestion
extends WaitWithTimeout {
    private Question question;
    private Matcher matcher;

    public WaitOnQuestion(Question question, Matcher matcher) {
        this.question = question;
        this.matcher = matcher;
        int durationInMillis = ((EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class)).getPropertyAsInteger((Enum)ThucydidesSystemProperty.WEBDRIVER_WAIT_FOR_TIMEOUT, Integer.valueOf(3000));
        this.timeout = Duration.ofMillis(durationInMillis);
    }

    @Override
    public <T extends Actor> void performAs(T actor) {
        actor.should(EventualConsequence.eventually(GivenWhenThen.seeThat(this.question, this.matcher)).waitingForNoLongerThan(this.timeout.toMillis()).milliseconds());
    }
}

