/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.waits;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.waits.WaitWithTimeout;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import org.awaitility.Awaitility;

public class WaitOnSupplier
extends WaitWithTimeout {
    private Callable<Boolean> expectedState;

    public WaitOnSupplier(Callable<Boolean> expectedState) {
        this.expectedState = expectedState;
        int durationInMillis = SystemEnvironmentVariables.currentEnvironmentVariables().getPropertyAsInteger((Enum)ThucydidesSystemProperty.WEBDRIVER_WAIT_FOR_TIMEOUT, Integer.valueOf(3000));
        this.timeout = Duration.ofMillis(durationInMillis);
    }

    @Override
    public <T extends Actor> void performAs(T actor) {
        Awaitility.await().pollInSameThread().atMost(this.timeout.toMillis(), TimeUnit.MILLISECONDS).until(this.expectedState);
    }
}

