/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import net.serenitybdd.core.steps.Instrumented;
import net.serenitybdd.markers.IsSilent;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.Question;

public abstract class RememberThat
implements Performable,
IsSilent {
    public static MemoryBuilder theValueOf(String memoryKey) {
        return new MemoryBuilder(memoryKey);
    }

    public static class MemoryBuilder {
        private final String memoryKey;

        MemoryBuilder(String memoryKey) {
            this.memoryKey = memoryKey;
        }

        public RememberThat is(Object value) {
            return (RememberThat)Instrumented.instanceOf(WithValue.class).withProperties(new Object[]{this.memoryKey, value});
        }

        public RememberThat isAnsweredBy(Question<?> value) {
            return (RememberThat)Instrumented.instanceOf(WithQuestion.class).withProperties(new Object[]{this.memoryKey, value});
        }
    }

    public static class WithQuestion
    extends RememberThat {
        private final String memoryKey;
        private final Question<?> question;

        @Override
        public <T extends Actor> void performAs(T actor) {
            actor.remember(this.memoryKey, this.question.answeredBy(actor));
        }

        public WithQuestion(String memoryKey, Question<?> question) {
            this.memoryKey = memoryKey;
            this.question = question;
        }
    }

    public static class WithValue
    extends RememberThat {
        private final String memoryKey;
        private final Object value;

        @Override
        public <T extends Actor> void performAs(T actor) {
            actor.remember(this.memoryKey, this.value);
        }

        public WithValue(String memoryKey, Object value) {
            this.memoryKey = memoryKey;
            this.value = value;
        }
    }
}

