/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.reports.email;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.serenitybdd.reports.email.CSSFormatter;
import net.serenitybdd.reports.email.Formatted;
import net.serenitybdd.reports.email.SerenitySinglePageReport;
import net.serenitybdd.reports.email.SinglePageHtmlReporterKt;
import net.serenitybdd.reports.email.templates.ThymeleafTemplateEngine;
import net.serenitybdd.reports.io.ReportIOKt;
import net.serenitybdd.reports.model.CustomReportFields;
import net.serenitybdd.reports.model.DurationsKt;
import net.serenitybdd.reports.model.FailuresByFeature;
import net.serenitybdd.reports.model.FrequentFailures;
import net.serenitybdd.reports.model.ReportInfo;
import net.serenitybdd.reports.model.ResultsCountKt;
import net.serenitybdd.reports.model.TagCoverage;
import net.serenitybdd.reports.model.TestResultSummary;
import net.serenitybdd.reports.model.TestResultsByFeature;
import net.serenitybdd.reports.model.UnstableFeatures;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.reports.ExtendedReport;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.util.EnvironmentVariables;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J$\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J$\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lnet/serenitybdd/reports/email/SinglePageHtmlReporter;", "Lnet/thucydides/core/reports/ExtendedReport;", "()V", "environmentVariables", "Lnet/thucydides/core/util/EnvironmentVariables;", "sourceDirectory", "Ljava/nio/file/Path;", "outputDirectory", "(Lnet/thucydides/core/util/EnvironmentVariables;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "generateReport", "getDescription", "", "getName", "newOutputFileIn", "Ljava/io/File;", "outputFileIn", "setOutputDirectory", "", "setSourceDirectory", "templateFields", "", "", "testOutcomes", "Lnet/thucydides/core/reports/TestOutcomes;", "writeHtmlReportTo", "fields", "serenity-single-page-report"})
public final class SinglePageHtmlReporter
implements ExtendedReport {
    @NotNull
    private final EnvironmentVariables environmentVariables;
    @NotNull
    private Path sourceDirectory;
    @NotNull
    private Path outputDirectory;

    public SinglePageHtmlReporter(@NotNull EnvironmentVariables environmentVariables, @NotNull Path sourceDirectory, @NotNull Path outputDirectory) {
        Intrinsics.checkNotNullParameter((Object)environmentVariables, (String)"environmentVariables");
        Intrinsics.checkNotNullParameter((Object)sourceDirectory, (String)"sourceDirectory");
        Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
        this.environmentVariables = environmentVariables;
        this.sourceDirectory = sourceDirectory;
        this.outputDirectory = outputDirectory;
    }

    public /* synthetic */ SinglePageHtmlReporter(EnvironmentVariables environmentVariables, Path path, Path path2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            path = SinglePageHtmlReporterKt.sourceDirectoryDefinedIn(environmentVariables);
        }
        if ((n & 4) != 0) {
            path2 = SinglePageHtmlReporterKt.outputDirectoryDefinedIn(environmentVariables);
        }
        this(environmentVariables, path, path2);
    }

    public SinglePageHtmlReporter() {
        Object object = Injectors.getInjector().getProvider(EnvironmentVariables.class).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getInjector().getProvide\u2026iables::class.java).get()");
        this((EnvironmentVariables)object, null, null, 6, null);
    }

    @NotNull
    public String getName() {
        return "single-page-html";
    }

    @NotNull
    public String getDescription() {
        return "Single Page HTML Summary";
    }

    public void setSourceDirectory(@NotNull Path sourceDirectory) {
        Intrinsics.checkNotNullParameter((Object)sourceDirectory, (String)"sourceDirectory");
        this.sourceDirectory = sourceDirectory;
    }

    public void setOutputDirectory(@NotNull Path outputDirectory) {
        Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
        this.outputDirectory = outputDirectory;
    }

    @NotNull
    public Path generateReport() {
        TestOutcomes testOutcomes = ReportIOKt.testOutcomesIn((Path)this.sourceDirectory).filteredByEnvironmentTags();
        Intrinsics.checkNotNullExpressionValue((Object)testOutcomes, (String)"testOutcomes");
        Map<String, Object> fields = this.templateFields(this.environmentVariables, testOutcomes);
        return this.writeHtmlReportTo(this.outputDirectory, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path writeHtmlReportTo(Path outputDirectory, Map<String, ? extends Object> fields) {
        File outputFile = this.newOutputFileIn(outputDirectory);
        Object object = outputFile;
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        Object object3 = object;
        Writer writer = new OutputStreamWriter((OutputStream)(object3 = (OutputStream)new FileOutputStream((File)object3)), (Charset)object2);
        BufferedWriter writer2 = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
        object = writer2;
        object2 = null;
        try {
            BufferedWriter it = (BufferedWriter)object;
            boolean bl = false;
            String template = (String)SerenitySinglePageReport.Companion.template().configuredIn(this.environmentVariables);
            new ThymeleafTemplateEngine().merge(template, fields, writer2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        object = outputFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"outputFile.toPath()");
        return object;
    }

    private final Map<String, Object> templateFields(EnvironmentVariables environmentVariables, TestOutcomes testOutcomes) {
        String reportTitle = (String)SerenitySinglePageReport.Companion.reportTitle().configuredIn(environmentVariables);
        String reportLink = (String)SerenitySinglePageReport.Companion.reportLink().configuredIn(environmentVariables);
        int scoreboardSize = ((Number)SerenitySinglePageReport.Companion.scoreboardSize().configuredIn(environmentVariables)).intValue();
        CustomReportFields customReportFields = new CustomReportFields(environmentVariables);
        List tagTypes = (List)SerenitySinglePageReport.Companion.tagTypes().configuredIn(environmentVariables);
        String tagCategoryTitle = (String)SerenitySinglePageReport.Companion.tagCategoryTitle().configuredIn(environmentVariables);
        boolean showFullTestResults = (Boolean)SerenitySinglePageReport.Companion.showFullTestResults().configuredIn(environmentVariables);
        Pair[] pairArray = new Pair[14];
        pairArray[0] = TuplesKt.to((Object)"testOutcomes", (Object)testOutcomes);
        pairArray[1] = TuplesKt.to((Object)"showFullTestResults", (Object)showFullTestResults);
        Object object = environmentVariables.getProperty("project.version", "");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"environmentVariables.get\u2026ty(\"project.version\", \"\")");
        String string = object;
        object = testOutcomes.getStartTime().orElse(ZonedDateTime.now()).toLocalDateTime();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"testOutcomes.startTime.o\u2026.now()).toLocalDateTime()");
        pairArray[2] = TuplesKt.to((Object)"report", (Object)new ReportInfo(reportTitle, reportLink, tagCategoryTitle, string, (LocalDateTime)object));
        int n = testOutcomes.getTotal();
        Map map = ResultsCountKt.countByResultLabelFrom((TestOutcomes)testOutcomes);
        Map map2 = ResultsCountKt.percentageByResultLabelFrom((TestOutcomes)testOutcomes);
        Long l = testOutcomes.getDuration();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"testOutcomes.duration");
        object = Duration.ofMillis(((Number)l).longValue());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ofMillis(testOutcomes.duration)");
        String string2 = DurationsKt.formattedDuration((Duration)object);
        object = testOutcomes.getOutcomes();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"testOutcomes.outcomes");
        String string3 = DurationsKt.formattedDuration((Duration)DurationsKt.clockDurationOf((List)object));
        object = testOutcomes.getOutcomes();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"testOutcomes.outcomes");
        String string4 = DurationsKt.formattedDuration((Duration)DurationsKt.averageDurationOf((List)object));
        object = testOutcomes.getOutcomes();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"testOutcomes.outcomes");
        String string5 = DurationsKt.formattedDuration((Duration)DurationsKt.maxDurationOf((List)object));
        object = testOutcomes.getOutcomes();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"testOutcomes.outcomes");
        pairArray[3] = TuplesKt.to((Object)"results", (Object)new TestResultSummary(n, map, map2, string2, string3, string4, string5, DurationsKt.formattedDuration((Duration)DurationsKt.minDurationOf((List)object))));
        pairArray[4] = TuplesKt.to((Object)"testFailuresPresent", (Object)(FailuresByFeature.Companion.from(testOutcomes).size() > 0 ? 1 : 0));
        pairArray[5] = TuplesKt.to((Object)"failuresByFeature", (Object)FailuresByFeature.Companion.from(testOutcomes));
        pairArray[6] = TuplesKt.to((Object)"resultsByFeature", (Object)TestResultsByFeature.Companion.from(testOutcomes));
        pairArray[7] = TuplesKt.to((Object)"frequentFailures", (Object)FrequentFailures.Companion.from(testOutcomes).withMaxOf(scoreboardSize));
        pairArray[8] = TuplesKt.to((Object)"unstableFeatures", (Object)UnstableFeatures.Companion.from(testOutcomes).withMaxOf(scoreboardSize));
        pairArray[9] = TuplesKt.to((Object)"coverage", (Object)TagCoverage.Companion.from(testOutcomes).forTagTypes(tagTypes));
        pairArray[10] = TuplesKt.to((Object)"customFields", (Object)customReportFields.getFieldNames());
        pairArray[11] = TuplesKt.to((Object)"customFieldValues", (Object)customReportFields.getValues());
        pairArray[12] = TuplesKt.to((Object)"formatted", (Object)new Formatted());
        pairArray[13] = TuplesKt.to((Object)"css", (Object)new CSSFormatter());
        HashMap fields = MapsKt.hashMapOf((Pair[])pairArray);
        return fields;
    }

    @NotNull
    public final File outputFileIn(@NotNull Path outputDirectory) {
        Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
        String reportName = (String)SerenitySinglePageReport.Companion.reportFilename().configuredIn(this.environmentVariables);
        File file = outputDirectory.resolve(reportName).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputDirectory.resolve(reportName).toFile()");
        return file;
    }

    @NotNull
    public final File newOutputFileIn(@NotNull Path outputDirectory) {
        Intrinsics.checkNotNullParameter((Object)outputDirectory, (String)"outputDirectory");
        outputDirectory.toFile().mkdirs();
        File outputFile = this.outputFileIn(outputDirectory);
        outputFile.createNewFile();
        return outputFile;
    }
}

