/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.reports.graphs;

import java.awt.Color;
import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.thucydides.core.model.TestResult;
import org.jetbrains.annotations.NotNull;
import org.knowm.xchart.BitmapEncoder;
import org.knowm.xchart.PieChart;
import org.knowm.xchart.PieChartBuilder;
import org.knowm.xchart.PieSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.PieStyler;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\r\u001a\u00020\b2\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lnet/serenitybdd/reports/graphs/ResultChart;", "", "data", "", "Lnet/thucydides/core/model/TestResult;", "", "(Ljava/util/Map;)V", "chart", "Lorg/knowm/xchart/PieChart;", "getChart", "()Lorg/knowm/xchart/PieChart;", "getData", "()Ljava/util/Map;", "donutChart", "saveTo", "", "savedGraph", "Ljava/io/File;", "Companion", "serenity-single-page-report"})
public final class ResultChart {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<TestResult, Integer> data;
    @NotNull
    private final PieChart chart;
    @NotNull
    private static final List<TestResult> DISPLAYED_TEST_RESULTS;
    @NotNull
    private static final Map<TestResult, Color> RESULT_COLORS;

    public ResultChart(@NotNull Map<TestResult, Integer> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.data = data;
        this.chart = this.donutChart(this.data);
    }

    @NotNull
    public final Map<TestResult, Integer> getData() {
        return this.data;
    }

    @NotNull
    public final PieChart getChart() {
        return this.chart;
    }

    @NotNull
    public final PieChart donutChart(@NotNull Map<TestResult, Integer> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        PieChart chart = ((PieChartBuilder)((PieChartBuilder)((PieChartBuilder)new PieChartBuilder().width(800)).height(600)).title("Test Results")).build();
        ((PieStyler)chart.getStyler()).setLegendVisible(false);
        ((PieStyler)chart.getStyler()).setChartTitleVisible(false);
        ((PieStyler)chart.getStyler()).setAnnotationType(PieStyler.AnnotationType.Label);
        ((PieStyler)chart.getStyler()).setAnnotationDistance(0.82);
        ((PieStyler)chart.getStyler()).setPlotContentSize(0.9);
        ((PieStyler)chart.getStyler()).setDefaultSeriesRenderStyle(PieSeries.PieSeriesRenderStyle.Donut);
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)DISPLAYED_TEST_RESULTS);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TestResult result = (TestResult)element$iv;
            boolean bl = false;
            chart.addSeries(result.toString(), (Number)data.get(result)).setFillColor(RESULT_COLORS.get(result));
        }
        Intrinsics.checkNotNullExpressionValue((Object)chart, (String)"chart");
        return chart;
    }

    public final void saveTo(@NotNull File savedGraph) {
        Intrinsics.checkNotNullParameter((Object)savedGraph, (String)"savedGraph");
        BitmapEncoder.saveBitmap((Chart)((Chart)this.chart), (String)savedGraph.getAbsolutePath(), (BitmapEncoder.BitmapFormat)BitmapEncoder.BitmapFormat.PNG);
    }

    static {
        Object[] objectArray = new TestResult[]{TestResult.SUCCESS, TestResult.PENDING, TestResult.IGNORED, TestResult.FAILURE, TestResult.ERROR, TestResult.COMPROMISED};
        DISPLAYED_TEST_RESULTS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)TestResult.SUCCESS, (Object)Color.decode("#61BD76")), TuplesKt.to((Object)TestResult.PENDING, (Object)Color.decode("#92DCCE")), TuplesKt.to((Object)TestResult.IGNORED, (Object)Color.decode("#ACB1B9")), TuplesKt.to((Object)TestResult.FAILURE, (Object)Color.decode("#F33446")), TuplesKt.to((Object)TestResult.ERROR, (Object)Color.decode("#FCB150")), TuplesKt.to((Object)TestResult.COMPROMISED, (Object)Color.decode("#A4528B"))};
        RESULT_COLORS = MapsKt.mapOf((Pair[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R%\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lnet/serenitybdd/reports/graphs/ResultChart$Companion;", "", "()V", "DISPLAYED_TEST_RESULTS", "", "Lnet/thucydides/core/model/TestResult;", "getDISPLAYED_TEST_RESULTS", "()Ljava/util/List;", "RESULT_COLORS", "", "Ljava/awt/Color;", "kotlin.jvm.PlatformType", "getRESULT_COLORS", "()Ljava/util/Map;", "serenity-single-page-report"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<TestResult> getDISPLAYED_TEST_RESULTS() {
            return DISPLAYED_TEST_RESULTS;
        }

        @NotNull
        public final Map<TestResult, Color> getRESULT_COLORS() {
            return RESULT_COLORS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

