/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit.spring.integration;

import java.lang.reflect.Method;
import net.serenitybdd.junit.spring.integration.SpringIntegrationRuleBase;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.junit4.statements.RunAfterTestMethodCallbacks;
import org.springframework.test.context.junit4.statements.RunBeforeTestMethodCallbacks;

public class SpringIntegrationMethodRule
extends SpringIntegrationRuleBase
implements MethodRule {
    private static final Logger LOG = LoggerFactory.getLogger(SpringIntegrationMethodRule.class);

    public Statement apply(Statement base, FrameworkMethod frameworkMethod, final Object target) {
        final Method testMethod = frameworkMethod.getMethod();
        Class<?> testClass = testMethod.getDeclaringClass();
        LOG.debug("Applying method rule to method {} of class {}", (Object)testMethod.getName(), (Object)testClass.getName());
        return super.apply(base, testClass, target, new SpringIntegrationRuleBase.StatementWrapper(){

            @Override
            public Statement apply(Statement next, TestContextManager testContextManager) {
                return new RunBeforeTestMethodCallbacks(next, target, testMethod, testContextManager);
            }
        }, new SpringIntegrationRuleBase.StatementWrapper(){

            @Override
            public Statement apply(Statement next, TestContextManager testContextManager) {
                return new RunAfterTestMethodCallbacks(next, target, testMethod, testContextManager);
            }
        });
    }
}

