/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.reports.model;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.thucydides.core.model.TestOutcome;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u0014\u0010\b\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a8\u0006\t"}, d2={"averageDurationOf", "Ljava/time/Duration;", "outcomes", "", "Lnet/thucydides/core/model/TestOutcome;", "formattedDuration", "", "duration", "maxDurationOf", "serenity-stats"})
public final class DurationsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Duration maxDurationOf(@NotNull List<? extends TestOutcome> outcomes) {
        long l;
        Intrinsics.checkParameterIsNotNull(outcomes, (String)"outcomes");
        if (outcomes.isEmpty()) {
            l = 0L;
        } else {
            void var3_3;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)outcomes;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void outcome;
                TestOutcome testOutcome = (TestOutcome)item$iv$iv;
                Collection collection = destination$iv$iv;
                Long l2 = outcome.getDuration();
                collection.add(l2);
            }
            Comparable comparable = CollectionsKt.max((Iterable)((List)var3_3));
            if (comparable == null) {
                Intrinsics.throwNpe();
            }
            l = ((Number)((Object)comparable)).longValue();
        }
        Duration duration = Duration.ofMillis(l);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMillis(\n     \u2026come.duration }.max()!!\n)");
        return duration;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Duration averageDurationOf(@NotNull List<? extends TestOutcome> outcomes) {
        long l;
        Intrinsics.checkParameterIsNotNull(outcomes, (String)"outcomes");
        if (outcomes.isEmpty()) {
            l = 0L;
        } else {
            void var3_3;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)outcomes;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void outcome;
                TestOutcome testOutcome = (TestOutcome)item$iv$iv;
                Collection collection = destination$iv$iv;
                Long l2 = outcome.getDuration();
                collection.add(l2);
            }
            l = (long)CollectionsKt.averageOfLong((Iterable)((List)var3_3));
        }
        Duration duration = Duration.ofMillis(l);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMillis(\n     \u2026on }.average().toLong()\n)");
        return duration;
    }

    @NotNull
    public static final String formattedDuration(@NotNull Duration duration) {
        Intrinsics.checkParameterIsNotNull((Object)duration, (String)"duration");
        long days = duration.toDays();
        long hours = duration.toHours() - days * (long)24;
        long minutes = duration.toMinutes() - days * (long)24 * (long)60 - hours * (long)60;
        long seconds = duration.getSeconds() - days * (long)24 * (long)60 * (long)60 - hours * (long)60 * (long)60 - minutes * (long)60;
        String durationInMilliseconds = "" + duration.toMillis() + "ms";
        String string = seconds > 0L ? " " + seconds + "s " : "0s ";
        StringBuilder stringBuilder = new StringBuilder().append(days > 0L ? "" + days + "d " : "").append(hours > 0L ? " " + hours + "h " : "").append(minutes > 0L ? " " + minutes + "m " : "");
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string3 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        String durationForSlowTests = stringBuilder.append(string3).toString();
        return duration.toMillis() < 1000L ? durationInMilliseconds : durationForSlowTests;
    }
}

