/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.reports.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.serenitybdd.reports.model.TestCaseDuration;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.model.TestTag;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tJ\u0006\u0010\u0017\u001a\u00020\u0018J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lnet/serenitybdd/reports/model/DurationBucket;", "", "duration", "", "minDurationInSeconds", "", "maxDurationInSeconds", "outcomes", "", "Lnet/serenitybdd/reports/model/TestCaseDuration;", "(Ljava/lang/String;JJLjava/util/List;)V", "getDuration", "()Ljava/lang/String;", "maxDurationInMilliseconds", "getMaxDurationInSeconds", "()J", "minDurationInMilliseconds", "getMinDurationInSeconds", "getOutcomes", "()Ljava/util/List;", "addOutcome", "", "testCaseDuration", "getTag", "Lnet/thucydides/core/model/TestTag;", "getTestOutcomes", "", "Lnet/thucydides/core/model/TestOutcome;", "withExamplesOfMatchingDuration", "title", "outcome", "serenity-stats"})
public final class DurationBucket {
    @NotNull
    private final String duration;
    private final long minDurationInSeconds;
    private final long maxDurationInSeconds;
    @NotNull
    private final List<TestCaseDuration> outcomes;
    private final long minDurationInMilliseconds;
    private final long maxDurationInMilliseconds;

    public DurationBucket(@NotNull String duration, long minDurationInSeconds, long maxDurationInSeconds, @NotNull List<TestCaseDuration> outcomes) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter(outcomes, (String)"outcomes");
        this.duration = duration;
        this.minDurationInSeconds = minDurationInSeconds;
        this.maxDurationInSeconds = maxDurationInSeconds;
        this.outcomes = outcomes;
        this.minDurationInMilliseconds = this.minDurationInSeconds * 1000L;
        this.maxDurationInMilliseconds = this.maxDurationInSeconds * 1000L;
    }

    @NotNull
    public final String getDuration() {
        return this.duration;
    }

    public final long getMinDurationInSeconds() {
        return this.minDurationInSeconds;
    }

    public final long getMaxDurationInSeconds() {
        return this.maxDurationInSeconds;
    }

    @NotNull
    public final List<TestCaseDuration> getOutcomes() {
        return this.outcomes;
    }

    public final void addOutcome(@NotNull TestCaseDuration testCaseDuration) {
        Intrinsics.checkNotNullParameter((Object)testCaseDuration, (String)"testCaseDuration");
        if (testCaseDuration.getTestOutcome().isDataDriven()) {
            String outcomeTitle = testCaseDuration.getTestOutcome().getTitle() + " (" + this.duration + ')';
            this.outcomes.add(this.withExamplesOfMatchingDuration(outcomeTitle, testCaseDuration.getTestOutcome()));
        } else {
            this.outcomes.add(testCaseDuration);
        }
    }

    private final TestCaseDuration withExamplesOfMatchingDuration(String title, TestOutcome outcome) {
        TestOutcome outcomeWithMatchingExamples = outcome.copy().removeTopLevelStepsNotMatching(arg_0 -> DurationBucket.withExamplesOfMatchingDuration$lambda$0(this, arg_0));
        long l = ((TestStep)outcomeWithMatchingExamples.getTestSteps().get(0)).getDuration();
        Intrinsics.checkNotNullExpressionValue((Object)outcomeWithMatchingExamples, (String)"outcomeWithMatchingExamples");
        return new TestCaseDuration(title, l, outcomeWithMatchingExamples);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TestOutcome> getTestOutcomes() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.outcomes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void outcome;
            TestCaseDuration testCaseDuration = (TestCaseDuration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(outcome.getTestOutcome());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final TestTag getTag() {
        TestTag testTag = TestTag.withName((String)this.duration).andType("Duration");
        Intrinsics.checkNotNullExpressionValue((Object)testTag, (String)"withName(duration).andType(\"Duration\")");
        return testTag;
    }

    private static final boolean withExamplesOfMatchingDuration$lambda$0(DurationBucket this$0, TestStep testStep) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        long l = this$0.minDurationInMilliseconds;
        long l2 = this$0.maxDurationInMilliseconds;
        long l3 = testStep.getDuration();
        return l <= l3 ? l3 < l2 : false;
    }
}

