/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.reports.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.serenitybdd.reports.model.DummyParentRequirementProvider;
import net.serenitybdd.reports.model.UnstableFeature;
import net.thucydides.model.domain.Story;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.reports.TestOutcomes;
import net.thucydides.model.reports.html.ReportNameProvider;
import net.thucydides.model.requirements.ParentRequirementProvider;
import net.thucydides.model.requirements.model.Requirement;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0002J \u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lnet/serenitybdd/reports/model/UnstableFeaturesBuilder;", "", "testOutcomes", "Lnet/thucydides/model/reports/TestOutcomes;", "<init>", "(Lnet/thucydides/model/reports/TestOutcomes;)V", "getTestOutcomes", "()Lnet/thucydides/model/reports/TestOutcomes;", "parentNameProvider", "Lnet/thucydides/model/requirements/ParentRequirementProvider;", "getParentNameProvider", "()Lnet/thucydides/model/requirements/ParentRequirementProvider;", "setParentNameProvider", "(Lnet/thucydides/model/requirements/ParentRequirementProvider;)V", "withRequirementsFrom", "withMaxOf", "", "Lnet/serenitybdd/reports/model/UnstableFeature;", "maxEntries", "", "defaultStoryNameOr", "", "displayName", "percentageFailures", "failingScenarios", "userStoryName", "featureReport", "outcome", "Lnet/thucydides/model/domain/TestOutcome;", "serenity-stats"})
@SourceDebugExtension(value={"SMAP\nUnstableFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnstableFeatures.kt\nnet/serenitybdd/reports/model/UnstableFeaturesBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,65:1\n1485#2:66\n1510#2,3:67\n1513#2,3:77\n774#2:84\n865#2,2:85\n381#3,7:70\n126#4:80\n153#4,3:81\n*S KotlinDebug\n*F\n+ 1 UnstableFeatures.kt\nnet/serenitybdd/reports/model/UnstableFeaturesBuilder\n*L\n28#1:66\n28#1:67,3\n28#1:77,3\n43#1:84\n43#1:85,2\n28#1:70,7\n29#1:80\n29#1:81,3\n*E\n"})
public final class UnstableFeaturesBuilder {
    @NotNull
    private final TestOutcomes testOutcomes;
    @NotNull
    private ParentRequirementProvider parentNameProvider;

    public UnstableFeaturesBuilder(@NotNull TestOutcomes testOutcomes) {
        Intrinsics.checkNotNullParameter((Object)testOutcomes, (String)"testOutcomes");
        this.testOutcomes = testOutcomes;
        this.parentNameProvider = new DummyParentRequirementProvider();
    }

    @NotNull
    public final TestOutcomes getTestOutcomes() {
        return this.testOutcomes;
    }

    @NotNull
    public final ParentRequirementProvider getParentNameProvider() {
        return this.parentNameProvider;
    }

    public final void setParentNameProvider(@NotNull ParentRequirementProvider parentRequirementProvider) {
        Intrinsics.checkNotNullParameter((Object)parentRequirementProvider, (String)"<set-?>");
        this.parentNameProvider = parentRequirementProvider;
    }

    @NotNull
    public final UnstableFeaturesBuilder withRequirementsFrom(@NotNull ParentRequirementProvider parentNameProvider) {
        Intrinsics.checkNotNullParameter((Object)parentNameProvider, (String)"parentNameProvider");
        this.parentNameProvider = parentNameProvider;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<UnstableFeature> withMaxOf(int maxEntries) {
        void $this$mapTo$iv$iv;
        Map $this$groupByTo$iv$iv;
        List list = this.testOutcomes.getUnsuccessfulTests().getOutcomes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOutcomes(...)");
        Iterable $this$groupBy$iv = list;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv = iterator.next();
            TestOutcome outcome = (TestOutcome)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = this.defaultStoryNameOr(outcome.getUserStory().getDisplayName());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)iterator.next();
            Object object = destination$iv$iv;
            boolean bl = false;
            String userStoryName = (String)entry.getKey();
            List outcomes = (List)entry.getValue();
            int n = outcomes.size();
            int n2 = this.percentageFailures(outcomes.size(), userStoryName, this.testOutcomes);
            Object e = outcomes.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            object.add(new UnstableFeature(userStoryName, n, n2, this.featureReport((TestOutcome)e)));
        }
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                UnstableFeature it = (UnstableFeature)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getFailurePercentage());
                it = (UnstableFeature)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getFailurePercentage()));
            }
        };
        return CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenByDescending;
            {
                this.$this_thenByDescending = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    UnstableFeature it = (UnstableFeature)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getFailureCount());
                    it = (UnstableFeature)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getFailureCount()));
                }
                return n;
            }
        }), (int)maxEntries);
    }

    private final String defaultStoryNameOr(String displayName) {
        String string = displayName;
        if (string == null) {
            string = "Undefined Story";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final int percentageFailures(int failingScenarios, String userStoryName, TestOutcomes testOutcomes) {
        void $this$filterTo$iv$iv;
        List list = testOutcomes.getOutcomes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOutcomes(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TestOutcome outcome = (TestOutcome)element$iv$iv;
            boolean bl = false;
            Story story = outcome.getUserStory();
            if (!Intrinsics.areEqual((Object)userStoryName, (Object)(story != null ? story.getDisplayName() : null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        int totalScenarios = TestOutcomes.of((Collection)((List)destination$iv$iv)).getTotal();
        return totalScenarios == 0 ? 0 : failingScenarios * 100 / totalScenarios;
    }

    @NotNull
    public final String featureReport(@NotNull TestOutcome outcome) {
        Intrinsics.checkNotNullParameter((Object)outcome, (String)"outcome");
        Optional parentRequirement = this.parentNameProvider.getParentRequirementFor(outcome);
        if (!parentRequirement.isPresent()) {
            return "#";
        }
        String string = new ReportNameProvider().forRequirement((Requirement)parentRequirement.get());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"forRequirement(...)");
        return string;
    }
}

