/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.reports.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.serenitybdd.reports.model.CSSColor;
import net.serenitybdd.reports.model.ScenarioSummaryResult;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.domain.TestResult;
import net.thucydides.model.domain.TestStep;
import net.thucydides.model.domain.stacktrace.FailureCause;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\u0015\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u0011\u0010\u0017\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000eR\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lnet/serenitybdd/reports/model/ScenarioSummary;", "", "title", "", "testData", "testResult", "Lnet/thucydides/model/domain/TestResult;", "reportName", "results", "", "Lnet/serenitybdd/reports/model/ScenarioSummaryResult;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lnet/thucydides/model/domain/TestResult;Ljava/lang/String;Ljava/util/List;)V", "getTitle", "()Ljava/lang/String;", "getTestData", "getReportName", "getResults", "()Ljava/util/List;", "result", "getResult", "color", "getColor", "errorMessage", "getErrorMessage", "hasExamples", "", "getHasExamples", "()Z", "Companion", "serenity-stats"})
public final class ScenarioSummary {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String title;
    @NotNull
    private final String testData;
    @NotNull
    private final String reportName;
    @NotNull
    private final List<ScenarioSummaryResult> results;
    @NotNull
    private final String result;
    @NotNull
    private final String color;
    @NotNull
    private final String errorMessage;
    private final boolean hasExamples;

    public ScenarioSummary(@NotNull String title, @NotNull String testData, @NotNull TestResult testResult, @NotNull String reportName, @NotNull List<ScenarioSummaryResult> results) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)testData, (String)"testData");
        Intrinsics.checkNotNullParameter((Object)testResult, (String)"testResult");
        Intrinsics.checkNotNullParameter((Object)reportName, (String)"reportName");
        Intrinsics.checkNotNullParameter(results, (String)"results");
        this.title = title;
        this.testData = testData;
        this.reportName = reportName;
        this.results = results;
        String string = testResult.toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        this.result = string;
        this.color = new CSSColor().forResult(testResult);
        this.errorMessage = this.results.isEmpty() ? "" : this.results.get(0).getErrorMessage();
        this.hasExamples = this.results.size() > 1;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final String getTestData() {
        return this.testData;
    }

    @NotNull
    public final String getReportName() {
        return this.reportName;
    }

    @NotNull
    public final List<ScenarioSummaryResult> getResults() {
        return this.results;
    }

    @NotNull
    public final String getResult() {
        return this.result;
    }

    @NotNull
    public final String getColor() {
        return this.color;
    }

    @NotNull
    public final String getErrorMessage() {
        return this.errorMessage;
    }

    public final boolean getHasExamples() {
        return this.hasExamples;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000e"}, d2={"Lnet/serenitybdd/reports/model/ScenarioSummary$Companion;", "", "<init>", "()V", "ofAllScenariosIn", "Lnet/serenitybdd/reports/model/ScenarioSummary;", "outcome", "Lnet/thucydides/model/domain/TestOutcome;", "ofFailingScenariosIn", "allScenariosIn", "", "Lnet/serenitybdd/reports/model/ScenarioSummaryResult;", "failingScenariosIn", "from", "serenity-stats"})
    @SourceDebugExtension(value={"SMAP\nScenarioSummary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScenarioSummary.kt\nnet/serenitybdd/reports/model/ScenarioSummary$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1557#2:63\n1628#2,3:64\n774#2:67\n865#2,2:68\n1557#2:70\n1628#2,3:71\n*S KotlinDebug\n*F\n+ 1 ScenarioSummary.kt\nnet/serenitybdd/reports/model/ScenarioSummary$Companion\n*L\n36#1:63\n36#1:64,3\n40#1:67\n40#1:68,2\n41#1:70\n41#1:71,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ScenarioSummary ofAllScenariosIn(@NotNull TestOutcome outcome) {
            ScenarioSummary scenarioSummary;
            Intrinsics.checkNotNullParameter((Object)outcome, (String)"outcome");
            if (outcome.isDataDriven()) {
                String string = outcome.getTitle();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTitle(...)");
                String string2 = outcome.getTestData();
                if (string2 == null) {
                    string2 = "";
                }
                TestResult testResult = outcome.getResult();
                Intrinsics.checkNotNullExpressionValue((Object)testResult, (String)"getResult(...)");
                String string3 = outcome.getHtmlReport();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getHtmlReport(...)");
                scenarioSummary = new ScenarioSummary(string, string2, testResult, string3, this.allScenariosIn(outcome));
            } else {
                scenarioSummary = this.from(outcome);
            }
            return scenarioSummary;
        }

        @NotNull
        public final ScenarioSummary ofFailingScenariosIn(@NotNull TestOutcome outcome) {
            ScenarioSummary scenarioSummary;
            Intrinsics.checkNotNullParameter((Object)outcome, (String)"outcome");
            if (outcome.isDataDriven()) {
                String string = outcome.getTitle();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTitle(...)");
                String string2 = outcome.getTestData();
                if (string2 == null) {
                    string2 = "";
                }
                TestResult testResult = outcome.getResult();
                Intrinsics.checkNotNullExpressionValue((Object)testResult, (String)"getResult(...)");
                String string3 = outcome.getHtmlReport();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getHtmlReport(...)");
                scenarioSummary = new ScenarioSummary(string, string2, testResult, string3, this.failingScenariosIn(outcome));
            } else {
                scenarioSummary = this.from(outcome);
            }
            return scenarioSummary;
        }

        /*
         * WARNING - void declaration
         */
        private final List<ScenarioSummaryResult> allScenariosIn(TestOutcome outcome) {
            void $this$mapTo$iv$iv;
            List list = outcome.getTestSteps();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTestSteps(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TestStep testStep = (TestStep)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                TestResult testResult = it.getResult();
                Intrinsics.checkNotNullExpressionValue((Object)testResult, (String)"getResult(...)");
                String string = it.getConciseErrorMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getConciseErrorMessage(...)");
                String string2 = it.getDescription();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDescription(...)");
                FailureCause failureCause = it.getException();
                String string3 = failureCause != null ? failureCause.getErrorType() : null;
                if (string3 == null) {
                    string3 = "";
                }
                collection.add(new ScenarioSummaryResult(testResult, string, string2, string3));
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<ScenarioSummaryResult> failingScenariosIn(TestOutcome outcome) {
            void $this$mapTo$iv$iv;
            TestStep it;
            Iterable $this$filterTo$iv$iv;
            List list = outcome.getTestSteps();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTestSteps(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (TestStep)element$iv$iv;
                boolean bl = false;
                if (!(it.isCompromised() != false || it.isFailure() != false || it.isError() != false)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (TestStep)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                TestResult testResult = it.getResult();
                Intrinsics.checkNotNullExpressionValue((Object)testResult, (String)"getResult(...)");
                String string = it.getConciseErrorMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getConciseErrorMessage(...)");
                String string2 = it.getDescription();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDescription(...)");
                FailureCause failureCause = it.getException();
                String string3 = failureCause != null ? failureCause.getErrorType() : null;
                if (string3 == null) {
                    string3 = "";
                }
                collection.add(new ScenarioSummaryResult(testResult, string, string2, string3));
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final ScenarioSummary from(@NotNull TestOutcome outcome) {
            Intrinsics.checkNotNullParameter((Object)outcome, (String)"outcome");
            String string = outcome.getTitle();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTitle(...)");
            TestResult testResult = outcome.getResult();
            Intrinsics.checkNotNullExpressionValue((Object)testResult, (String)"getResult(...)");
            String string2 = outcome.getHtmlReport();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHtmlReport(...)");
            TestResult testResult2 = outcome.getResult();
            Intrinsics.checkNotNullExpressionValue((Object)testResult2, (String)"getResult(...)");
            String string3 = outcome.getConciseErrorMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getConciseErrorMessage(...)");
            String string4 = outcome.getDescription();
            if (string4 == null) {
                string4 = "";
            }
            String string5 = outcome.getTestFailureErrorType();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getTestFailureErrorType(...)");
            return new ScenarioSummary(string, "", testResult, string2, CollectionsKt.listOf((Object)new ScenarioSummaryResult(testResult2, string3, string4, string5)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

