/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage;

import com.webcodepro.applecommander.storage.FileEntry;
import java.util.Comparator;

public class FileEntryComparator
implements Comparator<FileEntry> {
    private int columnIndex;
    private int displayMode;

    public FileEntryComparator(int columnIndex, int displayMode) {
        this.columnIndex = columnIndex;
        this.displayMode = displayMode;
    }

    @Override
    public int compare(FileEntry entry1, FileEntry entry2) {
        if (entry1 == null || entry2 == null) {
            return (entry1 == null ? -1 : 0) + (entry2 == null ? 1 : 0);
        }
        String column1 = entry1.getFileColumnData(this.displayMode).get(this.columnIndex);
        String column2 = entry2.getFileColumnData(this.displayMode).get(this.columnIndex);
        if (this.isAllDigits(column1) && this.isAllDigits(column2)) {
            int int1 = this.toInt(column1);
            int int2 = this.toInt(column2);
            return int1 - int2;
        }
        return column1.compareTo(column2);
    }

    protected boolean isAllDigits(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (Character.isDigit(ch) || ch == ',') continue;
            return false;
        }
        return true;
    }

    protected int toInt(String string) {
        StringBuffer buf = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (!Character.isDigit(ch)) continue;
            buf.append(ch);
        }
        return Integer.parseInt(buf.toString());
    }
}

