/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.filters;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.ui.AppleCommander;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class GutenbergFileFilter
implements FileFilter {
    private static final int RENDER_AS_TEXT = 0;
    private static final int RENDER_AS_HTML = 1;
    private static final int RENDER_AS_RTF = 2;
    private int rendering = 2;

    @Override
    public byte[] filter(FileEntry fileEntry) {
        byte[] fileData = fileEntry.getFileData();
        int offset = 0;
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream(fileData.length);
        PrintWriter printWriter = new PrintWriter(byteArray, true);
        while (offset < fileData.length) {
            fileData[offset] = (byte)(fileData[offset++] & 0x7F);
        }
        String preprocess = new String(fileData).trim();
        this.handleTranslation(preprocess, printWriter, this.rendering);
        printWriter.flush();
        return byteArray.toByteArray();
    }

    protected void handleTranslation(String raw, PrintWriter output, int rendering) {
        boolean ignoreBr = false;
        boolean inHeader = false;
        boolean inItalics = false;
        boolean inBold = false;
        boolean inCenter = false;
        boolean inUnderline = false;
        boolean inSuperscript = false;
        String cooked = raw.replaceAll("\\x00", "");
        cooked = cooked.replaceAll("<[a|A]1>", "");
        cooked = cooked.replaceAll("<e9>", "");
        cooked = cooked.replaceAll("<d1>", "");
        cooked = cooked.replaceAll("<s1>", "");
        cooked = cooked.replaceAll("<2>", "");
        cooked = cooked.replaceAll("<f9>", "");
        cooked = cooked.replaceAll("<i>", "");
        cooked = cooked.replaceAll("<i1>", "");
        cooked = cooked.replaceAll("<[h|H]1>(.*)", "<h1>$1</h1>");
        cooked = cooked.replaceAll("<[h|H]2>(.*)", "<h2>$1</h2>");
        cooked = cooked.replaceAll("<[h|H]3>(.*)", "<h3>$1</h3>");
        cooked = cooked.replaceAll("<[h|H]4>(.*)", "<h4>$1</h4>");
        cooked = cooked.replaceAll("<[n|N]1>(.*)", "<h1>$1</h1>");
        cooked = cooked.replaceAll("<[n|N]2>(.*)", "<h2>$1</h2>");
        cooked = cooked.replaceAll("<[n|N]3>(.*)", "<h3>$1</h3>");
        cooked = cooked.replaceAll("<[t|T]1>", "<p>");
        cooked = cooked.replaceAll("<[t|T]2>(.*)", "<p><bq1>$1</bq1>");
        cooked = cooked.replaceAll("<[t|T]3>(.*)", "<p><bq2>$1</bq2>");
        cooked = cooked.replaceAll("\\x0f", "</i>");
        cooked = cooked.replaceAll("\\x01(.*)", " <i>$1</i>");
        cooked = cooked.replaceAll("\\x02(.*)", " <i>$1</i>");
        cooked = cooked.replaceAll("~", "\"");
        cooked = cooked.replaceAll("_", "-");
        StringTokenizer newlines = new StringTokenizer(cooked, "\r", false);
        switch (rendering) {
            case 1: {
                output.println("<body><html>");
                break;
            }
            case 2: {
                output.print("{\\rtf1");
                output.print("{\\fonttbl{\\f0\\fmodern\\fprq1;}}");
                output.print("{\\*\\generator AppleCommander ");
                output.print(AppleCommander.VERSION);
                output.println(";}");
                output.print("\\f0 ");
                break;
            }
        }
        while (newlines.hasMoreTokens()) {
            boolean mode = false;
            String line = newlines.nextToken();
            StringTokenizer commands = new StringTokenizer(line, "<>", true);
            block73: while (commands.hasMoreTokens()) {
                String t = commands.nextToken();
                if (t.equals("<")) {
                    mode = true;
                    continue;
                }
                if (t.equals(">")) {
                    mode = false;
                    continue;
                }
                if (mode) {
                    if (t.startsWith("NF")) continue;
                    if (t.equalsIgnoreCase("i") && !inItalics) {
                        switch (rendering) {
                            case 1: {
                                output.print("<i>");
                                break;
                            }
                            case 2: {
                                output.print("\\i ");
                                break;
                            }
                        }
                        inItalics = true;
                        continue;
                    }
                    if (t.equalsIgnoreCase("/i")) {
                        switch (rendering) {
                            case 1: {
                                output.print("</i>");
                                break;
                            }
                            case 2: {
                                output.print("\\i0 ");
                                break;
                            }
                        }
                        inItalics = false;
                        continue;
                    }
                    if (t.equalsIgnoreCase("p") || t.startsWith("j") || t.startsWith("J")) {
                        switch (rendering) {
                            case 1: {
                                output.print("<p>");
                                break;
                            }
                            case 2: {
                                output.print("\\par \\par \\li0 ");
                                break;
                            }
                        }
                        ignoreBr = true;
                        continue;
                    }
                    if (t.equalsIgnoreCase("UL") && !inUnderline) {
                        switch (rendering) {
                            case 1: {
                                output.print("<u>");
                                break;
                            }
                            case 2: {
                                output.print("\\ul ");
                                break;
                            }
                        }
                        inUnderline = true;
                        continue;
                    }
                    if ((t.equalsIgnoreCase("KU") || t.equalsIgnoreCase("KL") || t.equalsIgnoreCase("UK")) && inUnderline) {
                        switch (rendering) {
                            case 1: {
                                output.print("</u>");
                                break;
                            }
                            case 2: {
                                output.print("\\ulnone ");
                                break;
                            }
                        }
                        inUnderline = false;
                        continue;
                    }
                    if ((t.equalsIgnoreCase("BO") || t.equalsIgnoreCase("b1")) && !inBold) {
                        switch (rendering) {
                            case 1: {
                                output.print("<b>");
                                break;
                            }
                            case 2: {
                                output.print("\\b ");
                                break;
                            }
                        }
                        inBold = true;
                        continue;
                    }
                    if (t.equalsIgnoreCase("KB")) {
                        switch (rendering) {
                            case 1: {
                                output.print("</b>");
                                break;
                            }
                            case 2: {
                                output.print("\\b0 ");
                                break;
                            }
                        }
                        inUnderline = false;
                        continue;
                    }
                    if ((t.equalsIgnoreCase("UFA") || t.equalsIgnoreCase("UFP") || t.equals("UFY") || t.equalsIgnoreCase("f1")) && !inSuperscript) {
                        switch (rendering) {
                            case 1: {
                                output.print("<sup>");
                                break;
                            }
                            case 2: {
                                output.print("\\super ");
                                break;
                            }
                        }
                        inSuperscript = true;
                        continue;
                    }
                    if ((t.equalsIgnoreCase("UFM") || t.equalsIgnoreCase("f2")) && inSuperscript) {
                        switch (rendering) {
                            case 1: {
                                output.print("</sup>");
                                break;
                            }
                            case 2: {
                                output.print("\\nosupersub ");
                                break;
                            }
                        }
                        inSuperscript = false;
                        continue;
                    }
                    if (t.equalsIgnoreCase("co") && !inCenter) {
                        switch (rendering) {
                            case 1: {
                                output.print("<center>");
                                break;
                            }
                            case 2: {
                                output.print("\\pard\\qc ");
                                break;
                            }
                        }
                        inCenter = true;
                        ignoreBr = true;
                        continue;
                    }
                    if (t.equalsIgnoreCase("h8") && inCenter) {
                        switch (rendering) {
                            case 1: {
                                output.print("</center>");
                                break;
                            }
                            case 2: {
                                output.print("\\par \\pard ");
                                break;
                            }
                        }
                        inCenter = false;
                        ignoreBr = true;
                        continue;
                    }
                    if (t.startsWith("h") && !inHeader) {
                        ignoreBr = true;
                        inHeader = true;
                        switch (rendering) {
                            case 1: {
                                if (t.equalsIgnoreCase("h1")) {
                                    output.print("<h1>");
                                    continue block73;
                                }
                                if (t.equalsIgnoreCase("h2")) {
                                    output.print("<h2>");
                                    continue block73;
                                }
                                if (t.equalsIgnoreCase("h3")) {
                                    output.print("<h3>");
                                    continue block73;
                                }
                                if (!t.equalsIgnoreCase("h4")) continue block73;
                                output.print("<h4>");
                                continue block73;
                            }
                            case 2: {
                                if (t.equalsIgnoreCase("h1")) {
                                    output.print("\\par\\par\\pard\\s1\\b\\fs48 ");
                                    continue block73;
                                }
                                if (t.equalsIgnoreCase("h2")) {
                                    output.print("\\par\\par\\pard\\s2\\b\\fs36 ");
                                    continue block73;
                                }
                                if (t.equalsIgnoreCase("h3")) {
                                    output.print("\\par\\par\\pard\\s3\\b\\fs27 ");
                                    continue block73;
                                }
                                if (!t.equalsIgnoreCase("h4")) continue block73;
                                output.print("\\par\\par\\pard\\s4\\b\\fs24 ");
                                continue block73;
                            }
                        }
                        output.println();
                        continue;
                    }
                    if (t.startsWith("/h") && inHeader) {
                        ignoreBr = true;
                        inHeader = false;
                        switch (rendering) {
                            case 1: {
                                if (t.equalsIgnoreCase("/h1")) {
                                    output.print("</h1>");
                                    continue block73;
                                }
                                if (t.equalsIgnoreCase("/h2")) {
                                    output.print("</h2>");
                                    continue block73;
                                }
                                if (t.equalsIgnoreCase("/h3")) {
                                    output.print("</h3>");
                                    continue block73;
                                }
                                if (!t.equalsIgnoreCase("/h4")) continue block73;
                                output.print("</h4>");
                                continue block73;
                            }
                            case 2: {
                                output.print("\\b0\\par\\fs24 ");
                                continue block73;
                            }
                        }
                        output.println();
                        continue;
                    }
                    if (t.startsWith("bq")) {
                        switch (rendering) {
                            case 1: {
                                if (t.equals("bq1")) {
                                    output.print("<blockquote>");
                                    break;
                                }
                                if (!t.equals("bq2")) break;
                                output.print("<blockquote><blockquote>");
                                break;
                            }
                            case 2: {
                                if (t.equals("bq1")) {
                                    output.print("\\pard\\li720 ");
                                    break;
                                }
                                if (!t.equals("bq2")) break;
                                output.print("\\pard\\li1440 ");
                                break;
                            }
                            default: {
                                output.print("     ");
                            }
                        }
                        ignoreBr = true;
                        continue;
                    }
                    if (!t.startsWith("/bq")) continue;
                    switch (rendering) {
                        case 1: {
                            if (t.equals("/bq1")) {
                                output.print("</blockquote>");
                                break;
                            }
                            if (!t.equals("/bq2")) break;
                            output.print("</blockquote></blockquote>");
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    ignoreBr = true;
                    continue;
                }
                output.print(t);
            }
            if (!ignoreBr) {
                this.handleReturn(output);
            }
            ignoreBr = false;
            switch (rendering) {
                case 1: {
                    if (inItalics) {
                        output.print("</i>");
                    }
                    if (inBold) {
                        output.print("</b>");
                    }
                    if (inUnderline) {
                        output.print("</u>");
                    }
                    if (!inSuperscript) break;
                    output.print("</sup>");
                    break;
                }
                case 2: {
                    if (inItalics) {
                        output.print("\\i0 ");
                    }
                    if (inBold) {
                        output.print("\\b0 ");
                    }
                    if (inUnderline) {
                        output.print("\\ulnone ");
                    }
                    if (!inSuperscript) break;
                    output.print("\\nosupersub ");
                    break;
                }
            }
            inItalics = false;
            inBold = false;
            inUnderline = false;
            inSuperscript = false;
            inHeader = false;
        }
        switch (rendering) {
            case 1: {
                output.println("</body></html>");
                break;
            }
            case 2: {
                output.println("}");
                break;
            }
        }
    }

    protected void handleReturn(PrintWriter printWriter) {
        if (this.isHtmlRendering()) {
            printWriter.println("<br>");
        } else if (this.isRtfRendering()) {
            printWriter.println("\\par");
        } else {
            printWriter.println();
        }
    }

    @Override
    public String getSuggestedFileName(FileEntry fileEntry) {
        Object fileName = fileEntry.getFilename().trim();
        String extension = ".txt";
        if (this.isHtmlRendering()) {
            extension = ".html";
        } else if (this.isRtfRendering()) {
            extension = ".rtf";
        }
        if (!((String)fileName).toLowerCase().endsWith(extension)) {
            fileName = (String)fileName + extension;
        }
        return fileName;
    }

    protected void setRendering(int rendering) {
        this.rendering = rendering;
    }

    public boolean isTextRendering() {
        return this.rendering == 0;
    }

    public boolean isHtmlRendering() {
        return this.rendering == 1;
    }

    public boolean isRtfRendering() {
        return this.rendering == 2;
    }

    public void selectTextRendering() {
        this.rendering = 0;
    }

    public void selectHtmlRendering() {
        this.rendering = 1;
    }

    public void selectRtfRendering() {
        this.rendering = 2;
    }
}

