/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.filters;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public class PascalTextFileFilter
implements FileFilter {
    private static final char NUL = '\u0000';
    private static final char CR = '\r';
    private static final char DLE = '\u0010';
    private static final int HEADER_SIZE = 1024;
    private static final int INDENT_BASE_VALUE = 32;

    @Override
    public byte[] filter(FileEntry fileEntry) {
        byte[] fileData = fileEntry.getFileData();
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream(fileData.length);
        PrintWriter printWriter = new PrintWriter(byteArray, true);
        block5: for (int offset = 1024; offset < fileData.length; ++offset) {
            char c = (char)(fileData[offset] & 0x7F);
            switch (c) {
                case '\u0000': {
                    continue block5;
                }
                case '\r': {
                    printWriter.println();
                    continue block5;
                }
                case '\u0010': {
                    if (offset + 1 >= fileData.length) continue block5;
                    int indent = fileData[++offset] - 32;
                    while (indent-- > 0) {
                        printWriter.print(' ');
                    }
                    continue block5;
                }
                default: {
                    printWriter.print(c);
                }
            }
        }
        return byteArray.toByteArray();
    }

    @Override
    public String getSuggestedFileName(FileEntry fileEntry) {
        Object fileName = fileEntry.getFilename().trim();
        if (!((String)fileName).toLowerCase().endsWith(".txt")) {
            fileName = (String)fileName + ".txt";
        }
        return fileName;
    }
}

