/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.dos33;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.DiskCorruptException;
import com.webcodepro.applecommander.storage.DiskException;
import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.DiskGeometry;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.os.dos33.DosFileEntry;
import com.webcodepro.applecommander.storage.os.dos33.DosSectorAddress;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DosFormatDisk
extends FormattedDisk {
    private TextBundle textBundle = StorageBundle.getInstance();
    public static final int TRACK_LOCATION_INDEX = 0;
    public static final int SECTOR_LOCATION_INDEX = 1;
    public static final int CATALOG_TRACK = 17;
    public static final int VTOC_SECTOR = 0;
    public static final int TRACK_SECTOR_PAIRS = 122;
    private static final String[] FILE_TYPES = new String[]{"T", "A", "I", "B", "S", "R", "a", "b"};
    private static final Map<String, String> FILE_TYPE_MAPPING = Map.of("T", "TXT", "I", "INT", "A", "BAS", "B", "BIN", "S", "$F1", "R", "REL", "a", "$F2", "b", "$F3");

    public DosFormatDisk(String filename, ImageOrder imageOrder) {
        super(filename, imageOrder);
    }

    public static DosFormatDisk[] create(String filename, ImageOrder imageOrder) {
        DosFormatDisk disk = new DosFormatDisk(filename, imageOrder);
        disk.format();
        return new DosFormatDisk[]{disk};
    }

    @Override
    public String getFormat() {
        byte[] vtoc = this.readVtoc();
        int version = Byte.toUnsignedInt(vtoc[3]);
        return String.format("DOS 3.%d", version);
    }

    @Override
    public List<FileEntry> getFiles() throws DiskException {
        ArrayList<FileEntry> list = new ArrayList<FileEntry>();
        byte[] vtoc = this.readVtoc();
        int track = AppleUtil.getUnsignedByte(vtoc[1]);
        int sector = AppleUtil.getUnsignedByte(vtoc[2]);
        HashSet<DosSectorAddress> visits = new HashSet<DosSectorAddress>();
        while (sector != 0) {
            DosSectorAddress address = new DosSectorAddress(track, sector);
            if (visits.contains(address)) {
                throw new DiskCorruptException(this.getFilename(), DiskCorruptException.Kind.RECURSIVE_DIRECTORY_STRUCTURE, address);
            }
            visits.add(address);
            byte[] catalogSector = this.readSector(track, sector);
            for (int offset = 11; offset < 255; offset += 35) {
                if (catalogSector[offset] == 0) continue;
                list.add(new DosFileEntry(this, track, sector, offset));
            }
            track = catalogSector[1];
            sector = catalogSector[2];
        }
        return list;
    }

    @Override
    public DosFileEntry createFile() throws DiskFullException {
        byte[] vtoc = this.readVtoc();
        int track = AppleUtil.getUnsignedByte(vtoc[1]);
        int sector = AppleUtil.getUnsignedByte(vtoc[2]);
        while (sector != 0) {
            byte[] catalogSector = this.readSector(track, sector);
            for (int offset = 11; offset < 255; offset += 35) {
                int value = AppleUtil.getUnsignedByte(catalogSector[offset]);
                if (value != 0 && value != 255) continue;
                return new DosFileEntry(this, track, sector, offset);
            }
            track = catalogSector[1];
            sector = catalogSector[2];
        }
        throw new DiskFullException(this.textBundle.get("DosFormatDisk.NoMoreSpaceError"), this.getFilename());
    }

    @Override
    public boolean canCreateDirectories() {
        return false;
    }

    @Override
    public boolean canCreateFile() {
        return true;
    }

    @Override
    public int getFreeSpace() {
        return this.getFreeSectors() * 256;
    }

    public int getFreeSectors() {
        byte[] vtoc = this.readVtoc();
        int freeSectors = 0;
        for (int offset = 56; offset < 255; ++offset) {
            byte bitmap = vtoc[offset];
            freeSectors += AppleUtil.getBitCount(bitmap);
        }
        return freeSectors;
    }

    @Override
    public int getUsedSpace() {
        return this.getUsedSectors() * 256;
    }

    public int getUsedSectors() {
        return this.getTotalSectors() - this.getFreeSectors();
    }

    public int getTotalSectors() {
        int tracks = this.getTracks();
        int sectors = this.getSectors();
        return tracks * sectors;
    }

    @Override
    public String getDiskName() {
        int volumeNumber = AppleUtil.getUnsignedByte(this.readVtoc()[6]);
        return this.textBundle.format("DosFormatDisk.DiskVolume", volumeNumber);
    }

    public byte[] readVtoc() {
        return this.readSector(17, 0);
    }

    public void writeVtoc(byte[] vtoc) {
        this.writeSector(17, 0, vtoc);
    }

    @Override
    public FormattedDisk.DiskUsage getDiskUsage() {
        return new DosDiskUsage();
    }

    public int getTracks() {
        byte[] vtoc = this.readVtoc();
        return AppleUtil.getUnsignedByte(vtoc[52]);
    }

    public int getSectors() {
        byte[] vtoc = this.readVtoc();
        return AppleUtil.getUnsignedByte(vtoc[53]);
    }

    @Override
    public int[] getBitmapDimensions() {
        int tracks = this.getTracks();
        int sectors = this.getSectors();
        return new int[]{tracks, sectors};
    }

    @Override
    public int getBitmapLength() {
        return this.getTotalSectors();
    }

    @Override
    public String[] getBitmapLabels() {
        return new String[]{this.textBundle.get("DosFormatDisk.Track"), this.textBundle.get("DosFormatDisk.Sector")};
    }

    @Override
    public List<FormattedDisk.DiskInformation> getDiskInformation() {
        List<FormattedDisk.DiskInformation> list = super.getDiskInformation();
        list.add(new FormattedDisk.DiskInformation((FormattedDisk)this, this.textBundle.get("DosFormatDisk.TotalSectors"), this.getTotalSectors()));
        list.add(new FormattedDisk.DiskInformation((FormattedDisk)this, this.textBundle.get("DosFormatDisk.FreeSectors"), this.getFreeSectors()));
        list.add(new FormattedDisk.DiskInformation((FormattedDisk)this, this.textBundle.get("DosFormatDisk.UsedSectors"), this.getUsedSectors()));
        list.add(new FormattedDisk.DiskInformation((FormattedDisk)this, this.textBundle.get("DosFormatDisk.TracksOnDisk"), this.getTracks()));
        list.add(new FormattedDisk.DiskInformation((FormattedDisk)this, this.textBundle.get("DosFormatDisk.SectorsOnDisk"), this.getSectors()));
        return list;
    }

    @Override
    public List<FormattedDisk.FileColumnHeader> getFileColumnHeaders(int displayMode) {
        ArrayList<FormattedDisk.FileColumnHeader> list = new ArrayList<FormattedDisk.FileColumnHeader>();
        switch (displayMode) {
            case 2: {
                list.add(new FormattedDisk.FileColumnHeader(this, " ", 1, 2, "locked"));
                list.add(new FormattedDisk.FileColumnHeader(this, this.textBundle.get("DosFormatDisk.Type"), 1, 2, "type"));
                list.add(new FormattedDisk.FileColumnHeader(this, this.textBundle.get("DosFormatDisk.SizeInSectors"), 3, 3, "sectors"));
                list.add(new FormattedDisk.FileColumnHeader(this, this.textBundle.get("Name"), 30, 1, "name"));
                break;
            }
            case 3: {
                list.add(new FormattedDisk.FileColumnHeader(this, " ", 1, 2, "locked"));
                list.add(new FormattedDisk.FileColumnHeader(this, this.textBundle.get("DosFormatDisk.Type"), 1, 2, "type"));
                list.add(new FormattedDisk.FileColumnHeader(this, this.textBundle.get("Name"), 30, 1, "name"));
                list.add(new FormattedDisk.FileColumnHeader(this, this.textBundle.get("SizeInBytes"), 6, 3, "size"));
                list.add(new FormattedDisk.FileColumnHeader(this, this.textBundle.get("DosFormatDisk.SizeInSectors"), 3, 3, "sectors"));
                list.add(new FormattedDisk.FileColumnHeader(this, this.textBundle.get("DeletedQ"), 7, 2, "deleted"));
                list.add(new FormattedDisk.FileColumnHeader(this, this.textBundle.get("DosFormatDisk.TrackAndSectorList"), 7, 2, "trackAndSectorList"));
                list.add(new FormattedDisk.FileColumnHeader(this, this.textBundle.get("DosFormatDisk.FileAddress"), 7, 3, "address"));
                break;
            }
            default: {
                list.addAll(super.getFileColumnHeaders(displayMode));
            }
        }
        return list;
    }

    @Override
    public boolean supportsDeletedFiles() {
        return true;
    }

    @Override
    public boolean canReadFileData() {
        return true;
    }

    @Override
    public boolean canWriteFileData() {
        return true;
    }

    @Override
    public boolean canHaveDirectories() {
        return false;
    }

    @Override
    public boolean canDeleteFile() {
        return true;
    }

    @Override
    public byte[] getFileData(FileEntry fileEntry) {
        if (!(fileEntry instanceof DosFileEntry)) {
            throw new IllegalArgumentException(this.textBundle.get("DosFormatDisk.InvalidFileEntryError"));
        }
        DosFileEntry dosEntry = (DosFileEntry)fileEntry;
        int filesize = dosEntry.getSectorsUsed();
        byte[] fileData = null;
        if (filesize <= 0) {
            fileData = new byte[]{};
            return fileData;
        }
        fileData = new byte[(dosEntry.getSectorsUsed() - 1) * 256];
        int track = dosEntry.getTrack();
        int sector = dosEntry.getSector();
        int offset = 0;
        while (track != 0) {
            int t;
            byte[] trackSectorList = this.readSector(track, sector);
            track = AppleUtil.getUnsignedByte(trackSectorList[1]);
            sector = AppleUtil.getUnsignedByte(trackSectorList[2]);
            for (int i = 12; i < 256 && (t = AppleUtil.getUnsignedByte(trackSectorList[i])) != 0; i += 2) {
                int s = AppleUtil.getUnsignedByte(trackSectorList[i + 1]);
                byte[] sectorData = this.readSector(t, s);
                System.arraycopy(sectorData, 0, fileData, offset, sectorData.length);
                offset += sectorData.length;
            }
        }
        return fileData;
    }

    @Override
    public void setFileData(FileEntry fileEntry, byte[] fileData) throws DiskFullException {
        this.setFileData((DosFileEntry)fileEntry, fileData);
    }

    protected void setFileData(DosFileEntry fileEntry, byte[] data) throws DiskFullException {
        int numberOfDataSectors = (data.length + 256 - 1) / 256;
        int numberOfSectors = numberOfDataSectors + (numberOfDataSectors + 122 - 1) / 122;
        if (numberOfSectors > this.getFreeSectors() + fileEntry.getSectorsUsed()) {
            throw new DiskFullException(this.textBundle.format("DosFormatDisk.NotEnoughSectorsError", numberOfSectors, this.getFreeSectors()), this.getFilename());
        }
        this.freeSectors(fileEntry);
        byte[] vtoc = this.readVtoc();
        int track = fileEntry.getTrack();
        int sector = fileEntry.getSector();
        if (track == 0 || track == 255) {
            track = 1;
            sector = 0;
            while (!this.isSectorFree(track, sector, vtoc)) {
                if (++sector < this.getSectors()) continue;
                ++track;
                sector = 0;
            }
            fileEntry.setTrack(track);
            fileEntry.setSector(sector);
        }
        this.setSectorUsed(track, sector, vtoc);
        byte[] trackSectorList = new byte[256];
        int offset = 0;
        int trackSectorOffset = 12;
        int totalSectors = 0;
        int t = 1;
        int s = 0;
        while (offset < data.length) {
            while (!this.isSectorFree(t, s, vtoc)) {
                if (++s < this.getSectors()) continue;
                ++t;
                s = 0;
            }
            this.setSectorUsed(t, s, vtoc);
            if (trackSectorOffset >= 256) {
                trackSectorList[1] = (byte)t;
                trackSectorList[2] = (byte)s;
                this.writeSector(track, sector, trackSectorList);
                trackSectorList = new byte[256];
                trackSectorOffset = 12;
                track = t;
                sector = s;
            } else {
                trackSectorList[trackSectorOffset] = (byte)t;
                trackSectorList[trackSectorOffset + 1] = (byte)s;
                trackSectorOffset += 2;
                byte[] sectorData = new byte[256];
                int length = Math.min(256, data.length - offset);
                System.arraycopy(data, offset, sectorData, 0, length);
                this.writeSector(t, s, sectorData);
                offset += 256;
            }
            ++totalSectors;
        }
        this.writeSector(track, sector, trackSectorList);
        fileEntry.setSectorsUsed(++totalSectors);
        this.writeVtoc(vtoc);
    }

    protected void freeSectors(DosFileEntry dosFileEntry) {
        byte[] vtoc = this.readVtoc();
        int track = dosFileEntry.getTrack();
        if (track == 255) {
            return;
        }
        int sector = dosFileEntry.getSector();
        while (track != 0) {
            int t;
            this.setSectorFree(track, sector, vtoc);
            byte[] trackSectorList = this.readSector(track, sector);
            track = AppleUtil.getUnsignedByte(trackSectorList[1]);
            sector = AppleUtil.getUnsignedByte(trackSectorList[2]);
            for (int i = 12; i < 256 && (t = AppleUtil.getUnsignedByte(trackSectorList[i])) != 0; i += 2) {
                int s = AppleUtil.getUnsignedByte(trackSectorList[i + 1]);
                this.setSectorFree(t, s, vtoc);
            }
        }
        this.writeVtoc(vtoc);
    }

    @Override
    public void format() {
        this.getImageOrder().format();
        this.format(15, 35, 16);
    }

    protected void format(int firstCatalogSector, int tracksPerDisk, int sectorsPerTrack) {
        this.writeBootCode();
        byte[] data = new byte[256];
        for (int sector = firstCatalogSector; sector > 0; --sector) {
            if (sector > 1) {
                data[1] = 17;
                data[2] = (byte)(sector - 1);
            } else {
                data[1] = 0;
                data[2] = 0;
            }
            this.writeSector(17, sector, data);
        }
        data[1] = 17;
        data[2] = (byte)firstCatalogSector;
        data[3] = 3;
        data[6] = -2;
        data[39] = 122;
        data[48] = 18;
        data[49] = 1;
        data[52] = (byte)tracksPerDisk;
        data[53] = (byte)sectorsPerTrack;
        data[55] = 1;
        for (int track = 0; track < tracksPerDisk; ++track) {
            for (int sector = 0; sector < sectorsPerTrack; ++sector) {
                if (track == 0 || track == 17) {
                    this.setSectorUsed(track, sector, data);
                    continue;
                }
                this.setSectorFree(track, sector, data);
            }
        }
        this.writeVtoc(data);
    }

    public boolean isSectorFree(int track, int sector, byte[] vtoc) {
        this.checkRange(track, sector);
        byte byt = vtoc[this.getFreeMapByte(track, sector)];
        return AppleUtil.isBitSet(byt, this.getFreeMapBit(sector));
    }

    public boolean isSectorUsed(int track, int sector, byte[] vtoc) {
        return !this.isSectorFree(track, sector, vtoc);
    }

    public void setSectorFree(int track, int sector, byte[] vtoc) {
        this.checkRange(track, sector);
        int offset = this.getFreeMapByte(track, sector);
        byte byt = vtoc[offset];
        vtoc[offset] = byt = AppleUtil.setBit(byt, this.getFreeMapBit(sector));
    }

    public void setSectorUsed(int track, int sector, byte[] vtoc) {
        this.checkRange(track, sector);
        int offset = this.getFreeMapByte(track, sector);
        byte byt = vtoc[offset];
        vtoc[offset] = byt = AppleUtil.clearBit(byt, this.getFreeMapBit(sector));
    }

    protected int getFreeMapByte(int track, int sector) {
        int trackOffset = track * 4;
        int sectorOffset = 1 - ((sector & 8) >> 3);
        return 56 + trackOffset + sectorOffset;
    }

    protected int getFreeMapBit(int sector) {
        int bit = sector & 7;
        return bit;
    }

    protected void checkRange(int track, int sector) {
        if (track > 50 || sector > 32) {
            throw new IllegalArgumentException(this.textBundle.format("DosFormatDisk.InvalidTrackAndSectorCombinationError", track, sector));
        }
    }

    @Override
    public int getLogicalDiskNumber() {
        return 0;
    }

    @Override
    public String getSuggestedFilename(String filename) {
        if (((String)filename).charAt(0) < '@') {
            filename = "A" + (String)filename;
        }
        int len = Math.min(((String)filename).length(), 30);
        return ((String)filename).toUpperCase().substring(0, len).trim();
    }

    @Override
    public String getSuggestedFiletype(String filename) {
        String what;
        String filetype = "B";
        int pos = filename.lastIndexOf(".");
        if (pos > 0 && "txt".equalsIgnoreCase(what = filename.substring(pos + 1))) {
            filetype = "T";
        }
        return filetype;
    }

    @Override
    public String[] getFiletypes() {
        return FILE_TYPES;
    }

    @Override
    public boolean needsAddress(String filetype) {
        return "B".equals(filetype);
    }

    @Override
    public boolean supportsDiskMap() {
        return true;
    }

    @Override
    public void changeImageOrder(ImageOrder imageOrder) {
        AppleUtil.changeImageOrderByTrackAndSector(this.getImageOrder(), imageOrder);
        this.setImageOrder(imageOrder);
    }

    @Override
    public DirectoryEntry createDirectory(String name) throws DiskFullException {
        throw new UnsupportedOperationException(this.textBundle.get("DirectoryCreationNotSupported"));
    }

    @Override
    public DiskGeometry getDiskGeometry() {
        return DiskGeometry.TRACK_SECTOR;
    }

    @Override
    public String toNativeFiletype(String prodosFiletype) {
        if (FILE_TYPE_MAPPING.containsKey(prodosFiletype)) {
            return prodosFiletype;
        }
        return FILE_TYPE_MAPPING.entrySet().stream().filter(e -> ((String)e.getValue()).equals(prodosFiletype)).map(Map.Entry::getKey).findFirst().orElse("B");
    }

    @Override
    public String toProdosFiletype(String nativeFiletype) {
        return FILE_TYPE_MAPPING.getOrDefault(nativeFiletype, "BIN");
    }

    private class DosDiskUsage
    implements FormattedDisk.DiskUsage {
        private int[] location = null;

        private DosDiskUsage() {
        }

        @Override
        public boolean hasNext() {
            return this.location == null || this.location[0] < DosFormatDisk.this.getTracks() && this.location[1] < DosFormatDisk.this.getSectors();
        }

        @Override
        public void next() {
            if (this.location == null) {
                this.location = new int[2];
            } else {
                this.location[1] = this.location[1] + 1;
                if (this.location[1] >= DosFormatDisk.this.getSectors()) {
                    this.location[1] = 0;
                    this.location[0] = this.location[0] + 1;
                }
            }
        }

        @Override
        public boolean isFree() {
            if (this.location == null || this.location.length != 2) {
                throw new IllegalArgumentException(StorageBundle.getInstance().get("DosFormatDisk.InvalidDimensionError"));
            }
            return DosFormatDisk.this.isSectorFree(this.location[0], this.location[1], DosFormatDisk.this.readVtoc());
        }

        @Override
        public boolean isUsed() {
            return !this.isFree();
        }
    }
}

