/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.prodos;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.DiskException;
import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFileEntry;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFormatDisk;
import com.webcodepro.applecommander.storage.os.prodos.ProdosSubdirectoryHeader;
import java.util.List;

public class ProdosDirectoryEntry
extends ProdosFileEntry
implements DirectoryEntry {
    private ProdosSubdirectoryHeader subdirectoryHeader;

    public ProdosDirectoryEntry(ProdosFormatDisk disk, int block, int offset, ProdosSubdirectoryHeader subdirectoryHeader) {
        super(disk, block, offset);
        this.subdirectoryHeader = subdirectoryHeader;
        subdirectoryHeader.setProdosDirectoryEntry(this);
    }

    public ProdosSubdirectoryHeader getSubdirectoryHeader() {
        return this.subdirectoryHeader;
    }

    @Override
    public String getDirname() {
        return this.getFilename();
    }

    @Override
    public List<FileEntry> getFiles() throws DiskException {
        return this.getDisk().getFiles(this.getSubdirectoryHeader().getFileEntryBlock());
    }

    @Override
    public ProdosFileEntry createFile() throws DiskFullException {
        return this.getDisk().createFile(this.getSubdirectoryHeader());
    }

    @Override
    public boolean canCreateDirectories() {
        return true;
    }

    @Override
    public boolean canCreateFile() {
        return true;
    }

    @Override
    public DirectoryEntry createDirectory(String name) throws DiskFullException {
        return this.getDisk().createDirectory(this.getSubdirectoryHeader(), name);
    }
}

