/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.physical;

public class ByteArrayImageLayout {
    private byte[] diskImage;
    private boolean changed;

    public ByteArrayImageLayout(byte[] diskImage) {
        this.setDiskImage(diskImage);
        this.changed = false;
    }

    public ByteArrayImageLayout(byte[] diskImage, boolean changed) {
        this.setDiskImage(diskImage);
        this.changed = changed;
    }

    public ByteArrayImageLayout(int size) {
        this.diskImage = new byte[size];
        this.changed = true;
    }

    public byte[] getDiskImage() {
        return this.diskImage;
    }

    public void setDiskImage(byte[] diskImage) {
        this.diskImage = diskImage;
        this.changed = true;
    }

    public int getPhysicalSize() {
        return this.diskImage != null ? this.diskImage.length : 0;
    }

    public byte[] readBytes(int start, int length) {
        byte[] buffer = new byte[length];
        System.arraycopy(this.diskImage, start, buffer, 0, length);
        return buffer;
    }

    public void writeBytes(int start, byte[] bytes) {
        this.changed = true;
        System.arraycopy(bytes, 0, this.diskImage, start, bytes.length);
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }
}

