/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.physical;

import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;

public class NibbleCodec {
    private static final TextBundle textBundle;
    private static final int[] writeTranslateTable53;
    private static final int[] readTranslateTable53;
    private static final int[] writeTranslateTable62;
    private static final int[] readTranslateTable62;
    public static final int[] DOS32_ADDRESS_PROLOGUE;
    public static final int[] DOS32_DATA_PROLOGUE;
    public static final int[] DOS33_ADDRESS_PROLOGUE;
    public static final int[] DOS33_DATA_PROLOGUE;

    public static int decodeOddEven(byte[] buffer, int offset) {
        int b1 = AppleUtil.getUnsignedByte(buffer[offset]);
        int b2 = AppleUtil.getUnsignedByte(buffer[offset + 1]);
        return (b1 << 1 | 1) & b2;
    }

    public static void encodeOddEven(byte[] buffer, int offset, int value) {
        buffer[offset] = (byte)(value >> 1 | 0xAA);
        buffer[offset + 1] = (byte)(value | 0xAA);
    }

    public static int identifySectorsPerTrack(byte[] trackData) {
        byte[] data2;
        int sectorsPerTrack = 0;
        try {
            data2 = NibbleCodec.readSectorFromTrack62(trackData, 0, 0, 16);
            if (data2 != null) {
                sectorsPerTrack = 16;
            }
        }
        catch (IllegalArgumentException data2) {
            // empty catch block
        }
        if (sectorsPerTrack == 0) {
            try {
                data2 = NibbleCodec.readSectorFromTrack53(trackData, 0, 0, 13);
                if (data2 != null) {
                    sectorsPerTrack = 13;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (sectorsPerTrack == 0) {
            throw new RuntimeException("unable to locate T0,S0 on disk");
        }
        return sectorsPerTrack;
    }

    public static byte[] readSectorFromTrack62(byte[] trackData, int track, int physicalSector, int sectorsPerTrack) {
        int offset = 0;
        byte[] addressField = new byte[14];
        boolean found = false;
        for (int attempts = sectorsPerTrack; !found && attempts >= 0; --attempts) {
            int nextOffset = NibbleCodec.locateField(DOS33_ADDRESS_PROLOGUE, trackData, addressField, offset);
            offset = nextOffset;
            int t = NibbleCodec.decodeOddEven(addressField, 5);
            int s = NibbleCodec.decodeOddEven(addressField, 7);
            found = t == track && s == physicalSector;
        }
        if (!found) {
            throw new IllegalArgumentException(textBundle.format("NibbleOrder.InvalidPhysicalSectorError", physicalSector, track, 1));
        }
        byte[] dataField = new byte[349];
        NibbleCodec.locateField(DOS33_DATA_PROLOGUE, trackData, dataField, offset);
        byte[] buffer = new byte[342];
        int checksum = 0;
        for (int i = 0; i < buffer.length; ++i) {
            int b = AppleUtil.getUnsignedByte(dataField[i + 3]);
            checksum ^= readTranslateTable62[b];
            if (i < 86) {
                buffer[buffer.length - i - 1] = (byte)checksum;
                continue;
            }
            buffer[i - 86] = (byte)checksum;
        }
        if ((checksum ^= readTranslateTable62[AppleUtil.getUnsignedByte(dataField[345])]) != 0) {
            return null;
        }
        byte[] sectorData = new byte[256];
        for (int i = 0; i < sectorData.length; ++i) {
            int b1 = AppleUtil.getUnsignedByte(buffer[i]);
            int lowerBits = buffer.length - i % 86 - 1;
            int b2 = AppleUtil.getUnsignedByte(buffer[lowerBits]);
            int shiftPairs = i / 86 * 2;
            int[] reverseValues = new int[]{0, 2, 1, 3};
            int b = b1 << 2 | reverseValues[b2 >> shiftPairs & 3];
            sectorData[i] = (byte)b;
        }
        return sectorData;
    }

    public static byte[] readSectorFromTrack53(byte[] trackData, int track, int physicalSector, int sectorsPerTrack) {
        int offset = 0;
        byte[] addressField = new byte[14];
        boolean found = false;
        for (int attempts = sectorsPerTrack; !found && attempts >= 0; --attempts) {
            int nextOffset = NibbleCodec.locateField(DOS32_ADDRESS_PROLOGUE, trackData, addressField, offset);
            offset = nextOffset;
            int t = NibbleCodec.decodeOddEven(addressField, 5);
            int s = NibbleCodec.decodeOddEven(addressField, 7);
            found = t == track && s == physicalSector;
        }
        if (!found) {
            throw new IllegalArgumentException(textBundle.format("NibbleOrder.InvalidPhysicalSectorError", physicalSector, track, 1));
        }
        byte[] dataField = new byte[417];
        NibbleCodec.locateField(DOS33_DATA_PROLOGUE, trackData, dataField, offset);
        byte[] buffer = new byte[410];
        int checksum = 0;
        for (int i = 0; i < buffer.length; ++i) {
            int b = AppleUtil.getUnsignedByte(dataField[i + 3]);
            checksum ^= readTranslateTable53[b];
            if (i < 154) {
                buffer[buffer.length - i - 1] = (byte)checksum;
                continue;
            }
            buffer[i - 154] = (byte)checksum;
        }
        if ((checksum ^= readTranslateTable53[AppleUtil.getUnsignedByte(dataField[413])]) != 0) {
            return null;
        }
        byte[] sectorData = new byte[256];
        offset = 0;
        for (int i = 50; i >= 0; --i) {
            int a76543 = Byte.toUnsignedInt(buffer[i]);
            int b76543 = Byte.toUnsignedInt(buffer[51 + i]);
            int c76543 = Byte.toUnsignedInt(buffer[102 + i]);
            int d76543 = Byte.toUnsignedInt(buffer[153 + i]);
            int e76543 = Byte.toUnsignedInt(buffer[204 + i]);
            int a210d2e2 = Byte.toUnsignedInt(buffer[256 + i]);
            int b210d1e1 = Byte.toUnsignedInt(buffer[307 + i]);
            int c210d0e0 = Byte.toUnsignedInt(buffer[358 + i]);
            sectorData[offset++] = (byte)(a76543 << 3 | a210d2e2 >> 2 & 7);
            sectorData[offset++] = (byte)(b76543 << 3 | b210d1e1 >> 2 & 7);
            sectorData[offset++] = (byte)(c76543 << 3 | c210d0e0 >> 2 & 7);
            sectorData[offset++] = (byte)(d76543 << 3 | a210d2e2 << 1 & 4 | b210d1e1 & 2 | c210d0e0 >> 1 & 1);
            sectorData[offset++] = (byte)(e76543 << 3 | a210d2e2 << 2 & 4 | b210d1e1 << 1 & 2 | c210d0e0 & 1);
        }
        sectorData[255] = (byte)(buffer[255] << 3 | buffer[409] & 7);
        return sectorData;
    }

    public static int locateField(int[] prologue, byte[] trackData, byte[] fieldData, int startingOffset) {
        int i;
        int position = 0;
        for (i = startingOffset; i < trackData.length + fieldData.length; ++i) {
            int offset = i % trackData.length;
            int b = AppleUtil.getUnsignedByte(trackData[offset]);
            if (position == 0 && b == prologue[0]) {
                fieldData[position++] = (byte)b;
                continue;
            }
            if (position == 1 && b == prologue[1]) {
                fieldData[position++] = (byte)b;
                continue;
            }
            if (position == 2 && b == prologue[2]) {
                fieldData[position++] = (byte)b;
                continue;
            }
            if (position >= 3 && position <= fieldData.length) {
                if (position < fieldData.length) {
                    fieldData[position++] = (byte)b;
                }
                if (position != fieldData.length) continue;
                break;
            }
            position = 0;
        }
        return i % trackData.length;
    }

    public static void writeSectorToTrack(byte[] trackData, byte[] sectorData, int track, int physicalSector, int sectorsPerTrack) {
        int offset = 0;
        byte[] addressField = new byte[14];
        boolean found = false;
        while (!found && offset < trackData.length) {
            int nextOffset = NibbleCodec.locateField(DOS33_ADDRESS_PROLOGUE, trackData, addressField, offset);
            if (nextOffset < offset) {
                throw new IllegalArgumentException(textBundle.format("NibbleOrder.InvalidPhysicalSectorError", physicalSector, track, 2));
            }
            offset = nextOffset;
            int t = NibbleCodec.decodeOddEven(addressField, 5);
            int s = NibbleCodec.decodeOddEven(addressField, 7);
            found = t == track && s == physicalSector;
        }
        if (!found) {
            throw new IllegalArgumentException(textBundle.format("NibbleOrder.InvalidPhysicalSectorError", physicalSector, track, 2));
        }
        int[] bb00 = new int[256];
        int[] bc00 = new int[86];
        int x = 0;
        int y = 2;
        while (true) {
            if (--y < 0) {
                y += 256;
            }
            int a = AppleUtil.getUnsignedByte(sectorData[y]);
            int n = x;
            bc00[n] = bc00[n] << 1;
            int n2 = x;
            bc00[n2] = bc00[n2] | a & 1;
            int n3 = x;
            bc00[n3] = bc00[n3] << 1;
            int n4 = x++;
            bc00[n4] = bc00[n4] | (a >>= 1) & 1;
            bb00[y] = a >>= 1;
            if (x < 86) continue;
            x = 0;
            if (y == 0) break;
        }
        x = 0;
        while (x < 86) {
            int n = x++;
            bc00[n] = bc00[n] & 0x3F;
        }
        byte[] diskData = new byte[343];
        int pos = 0;
        for (y = 86; y > 0; --y) {
            diskData[pos++] = y == 86 ? (byte)writeTranslateTable62[bc00[y - 1]] : (byte)writeTranslateTable62[bc00[y] ^ bc00[y - 1]];
        }
        diskData[pos++] = (byte)writeTranslateTable62[bc00[0] ^ bb00[y]];
        for (y = 1; y < 256; ++y) {
            diskData[pos++] = (byte)writeTranslateTable62[bb00[y] ^ bb00[y - 1]];
        }
        diskData[pos++] = (byte)writeTranslateTable62[bb00[255]];
        byte[] dataFieldPrologue = new byte[3];
        offset = NibbleCodec.locateField(DOS33_DATA_PROLOGUE, trackData, dataFieldPrologue, offset);
        for (int i = 0; i < diskData.length; ++i) {
            pos = (offset + i) % trackData.length;
            trackData[pos] = diskData[i];
        }
    }

    static {
        int i;
        textBundle = StorageBundle.getInstance();
        writeTranslateTable53 = new int[]{171, 173, 174, 175, 181, 182, 183, 186, 187, 189, 190, 191, 214, 215, 218, 219, 221, 222, 223, 234, 235, 237, 238, 239, 245, 246, 247, 250, 251, 253, 254, 255};
        readTranslateTable53 = new int[256];
        for (i = 0; i < writeTranslateTable53.length; ++i) {
            NibbleCodec.readTranslateTable53[NibbleCodec.writeTranslateTable53[i]] = i;
        }
        writeTranslateTable62 = new int[]{150, 151, 154, 155, 157, 158, 159, 166, 167, 171, 172, 173, 174, 175, 178, 179, 180, 181, 182, 183, 185, 186, 187, 188, 189, 190, 191, 203, 205, 206, 207, 211, 214, 215, 217, 218, 219, 220, 221, 222, 223, 229, 230, 231, 233, 234, 235, 236, 237, 238, 239, 242, 243, 244, 245, 246, 247, 249, 250, 251, 252, 253, 254, 255};
        readTranslateTable62 = new int[256];
        for (i = 0; i < writeTranslateTable62.length; ++i) {
            NibbleCodec.readTranslateTable62[NibbleCodec.writeTranslateTable62[i]] = i;
        }
        DOS32_ADDRESS_PROLOGUE = new int[]{213, 170, 181};
        DOS32_DATA_PROLOGUE = new int[]{213, 170, 173};
        DOS33_ADDRESS_PROLOGUE = new int[]{213, 170, 150};
        DOS33_DATA_PROLOGUE = new int[]{213, 170, 173};
    }
}

