/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.physical;

import com.webcodepro.applecommander.storage.physical.ByteArrayImageLayout;
import com.webcodepro.applecommander.storage.physical.DosOrder;
import com.webcodepro.applecommander.storage.physical.NibbleCodec;
import java.util.Arrays;

public class NibbleOrder
extends DosOrder {
    public static final int[] DOS_SECTOR_SKEW = new int[]{0, 13, 11, 9, 7, 5, 3, 1, 14, 12, 10, 8, 6, 4, 2, 15};
    private int sectorsPerTrack = 16;

    public NibbleOrder(ByteArrayImageLayout diskImageManager) {
        super(diskImageManager);
        byte[] trackData = this.readTrackData(0);
        this.sectorsPerTrack = NibbleCodec.identifySectorsPerTrack(trackData);
    }

    protected byte[] readTrackData(int track) {
        int trackSize = this.getPhysicalSize() / this.getTracksPerDisk();
        return this.readBytes(track * trackSize, trackSize);
    }

    protected void writeTrackData(int track, byte[] trackData) {
        int trackSize = this.getPhysicalSize() / this.getTracksPerDisk();
        this.writeBytes(track * trackSize, trackData);
    }

    @Override
    public byte[] readSector(int track, int dosSector) throws IllegalArgumentException {
        if (this.sectorsPerTrack == 16) {
            int sector = DOS_SECTOR_SKEW[dosSector];
            byte[] trackData = this.readTrackData(track);
            return NibbleCodec.readSectorFromTrack62(trackData, track, sector, this.getSectorsPerTrack());
        }
        byte[] trackData = this.readTrackData(track);
        return NibbleCodec.readSectorFromTrack53(trackData, track, dosSector, this.getSectorsPerTrack());
    }

    @Override
    public void writeSector(int track, int dosSector, byte[] sectorData) throws IllegalArgumentException {
        if (this.sectorsPerTrack == 13) {
            throw new RuntimeException("writing to 13-sector disks not supported");
        }
        int sector = DOS_SECTOR_SKEW[dosSector];
        byte[] trackData = this.readTrackData(track);
        NibbleCodec.writeSectorToTrack(trackData, sectorData, track, sector, this.getSectorsPerTrack());
        this.writeTrackData(track, trackData);
    }

    @Override
    public int getTracksPerDisk() {
        return 35;
    }

    @Override
    public int getSectorsPerTrack() {
        return this.sectorsPerTrack;
    }

    @Override
    public int getBlocksOnDevice() {
        return 280;
    }

    @Override
    public void format() {
        if (this.sectorsPerTrack == 13) {
            throw new RuntimeException("formatting 13-sector disks not supported");
        }
        byte[] diskImage = new byte[232960];
        Arrays.fill(diskImage, (byte)-1);
        this.getDiskImageManager().setDiskImage(diskImage);
        byte[] addressField = new byte[14];
        byte[] dataField = new byte[349];
        Arrays.fill(dataField, (byte)-106);
        byte[] addressPrologue = new byte[]{-43, -86, -106};
        byte[] dataPrologue = new byte[]{-43, -86, -83};
        byte[] epilogue = new byte[]{-34, -86, -21};
        System.arraycopy(addressPrologue, 0, addressField, 0, 3);
        System.arraycopy(epilogue, 0, addressField, 11, 3);
        System.arraycopy(dataPrologue, 0, dataField, 0, 3);
        System.arraycopy(epilogue, 0, dataField, 346, 3);
        int addressSync = 43;
        int dataSync = 10;
        int volume = 254;
        for (int track = 0; track < this.getTracksPerDisk(); ++track) {
            byte[] trackData = this.readTrackData(track);
            int offset = 0;
            for (int sector = 0; sector < this.getSectorsPerTrack(); ++sector) {
                NibbleCodec.encodeOddEven(addressField, 3, volume);
                NibbleCodec.encodeOddEven(addressField, 5, track);
                NibbleCodec.encodeOddEven(addressField, 7, sector);
                NibbleCodec.encodeOddEven(addressField, 9, volume ^ track ^ sector);
                System.arraycopy(addressField, 0, trackData, offset += addressSync, addressField.length);
                offset += addressField.length;
                System.arraycopy(dataField, 0, trackData, offset += dataSync, dataField.length);
                offset += dataField.length;
            }
            this.writeTrackData(track, trackData);
        }
    }
}

