/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.physical;

import com.webcodepro.applecommander.storage.os.dos33.DosSectorAddress;
import com.webcodepro.applecommander.storage.physical.ByteArrayImageLayout;
import com.webcodepro.applecommander.storage.physical.DosOrder;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.storage.physical.NibbleCodec;
import com.webcodepro.applecommander.storage.physical.NibbleOrder;
import com.webcodepro.applecommander.storage.physical.ProdosOrder;
import com.webcodepro.applecommander.util.AppleUtil;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class WozOrder
extends ImageOrder {
    public static final int WOZ1_MAGIC = 828002135;
    public static final int WOZ2_MAGIC = 844779351;
    public static final int INFO_CHUNK_ID = 1330007625;
    public static final int TMAP_CHUNK_ID = 1346456916;
    public static final int TRKS_CHUNK_ID = 1397445204;
    public static final int FLUX_CHUNK_ID = 1414091351;
    public static final int META_CHUNK_ID = 1096041805;
    private InfoChunk info;
    private Map<String, String> meta = new HashMap<String, String>();
    private List<TmapChunk> tmap = new ArrayList<TmapChunk>();
    private List<TrkInfo> trks = new ArrayList<TrkInfo>();
    private boolean blockDevice;
    private boolean trackAndSectorDevice;
    private int blocksOnDevice;
    private int sectorsPerTrack;
    private Function<Integer, byte[]> trackReader = null;
    private Function<Integer, byte[]> blockReader = this::readBlock525;
    private BiFunction<Integer, Integer, byte[]> sectorReader = this::readSector525;

    public WozOrder(ByteArrayImageLayout layout) {
        super(layout);
        ByteBuffer bb = ByteBuffer.wrap(layout.getDiskImage());
        bb.order(ByteOrder.LITTLE_ENDIAN);
        int sig = bb.getInt();
        int test = bb.getInt();
        int testExpected = 168626943;
        if (sig == 828002135 && test == 168626943) {
            this.trackReader = this::readTrackDataWOZ1;
        } else if (sig == 844779351 && test == 168626943) {
            this.trackReader = this::readTrackDataWOZ2;
        } else {
            throw new RuntimeException("Not a WOZ1 or WOZ2 format file.");
        }
        bb.getInt();
        Consumer<byte[]> tmapReader = this::readTmapChunk525;
        while (bb.hasRemaining()) {
            int chunkId = bb.getInt();
            int chunkSize = bb.getInt();
            byte[] data = new byte[chunkSize];
            bb.get(data);
            switch (chunkId) {
                case 1330007625: {
                    this.info = new InfoChunk(data);
                    if (this.info.getDiskType() == 1) {
                        this.blockDevice = false;
                        this.trackAndSectorDevice = true;
                        this.blocksOnDevice = 280;
                        tmapReader = this::readTmapChunk525;
                        this.blockReader = this::readBlock525;
                        this.sectorReader = this::readSector525;
                        break;
                    }
                    this.blockDevice = true;
                    this.trackAndSectorDevice = false;
                    this.blocksOnDevice = this.info.getDiskSides() * 800;
                    tmapReader = this::readTmapChunk35;
                    this.sectorReader = this::readSector35;
                    break;
                }
                case 1346456916: {
                    tmapReader.accept(data);
                    break;
                }
                case 1397445204: {
                    this.readTrksChunk(data);
                }
                case 1096041805: {
                    this.readMetaChunk(data);
                }
            }
        }
        byte[] trackData = this.readTrackData(0);
        this.sectorsPerTrack = NibbleCodec.identifySectorsPerTrack(trackData);
    }

    @Override
    public String getName() {
        return "WOZ Disk Image";
    }

    @Override
    public int getPhysicalSize() {
        return this.blocksOnDevice * 512;
    }

    @Override
    public int getSectorsPerTrack() {
        return this.sectorsPerTrack;
    }

    @Override
    public byte[] readBlock(int block) {
        return this.blockReader.apply(block);
    }

    public byte[] readBlock525(int block) {
        if (this.sectorsPerTrack == 13) {
            return new byte[512];
        }
        DosSectorAddress[] sectors = DosOrder.blockToSectors525(block);
        byte[] sector1 = this.readSector(sectors[0].track, sectors[0].sector);
        byte[] sector2 = this.readSector(sectors[1].track, sectors[1].sector);
        byte[] blockData = new byte[512];
        System.arraycopy(sector1, 0, blockData, 0, 256);
        System.arraycopy(sector2, 0, blockData, 256, 256);
        return blockData;
    }

    public DosSectorAddress blockToSector35(int block) {
        int sector = block;
        int maxSectorsOnTrack = 0;
        int track = 0;
        block0: for (int i = 0; i < this.info.getDiskSides(); ++i) {
            for (int s = 12; s >= 8; --s) {
                maxSectorsOnTrack = s;
                for (int c = 0; c < 8; ++c) {
                    if (sector < maxSectorsOnTrack) break block0;
                    sector -= s;
                    ++track;
                }
            }
        }
        return new DosSectorAddress(track, sector);
    }

    @Override
    public void writeBlock(int block, byte[] data) {
        throw new RuntimeException("WOZ Disk Image does not support writing at this time");
    }

    @Override
    public boolean isBlockDevice() {
        return this.blockDevice;
    }

    @Override
    public boolean isTrackAndSectorDevice() {
        return this.trackAndSectorDevice;
    }

    @Override
    public int getBlocksOnDevice() {
        return this.blocksOnDevice;
    }

    @Override
    public byte[] readSector(int track, int sector) throws IllegalArgumentException {
        return this.sectorReader.apply(track, sector);
    }

    public byte[] readSector525(int track, int sector) throws IllegalArgumentException {
        if (this.sectorsPerTrack == 16) {
            sector = NibbleOrder.DOS_SECTOR_SKEW[sector];
            byte[] trackData = this.readTrackData(track);
            return NibbleCodec.readSectorFromTrack62(trackData, track, sector, this.getSectorsPerTrack());
        }
        byte[] trackData = this.readTrackData(track);
        return NibbleCodec.readSectorFromTrack53(trackData, track, sector, this.getSectorsPerTrack());
    }

    public byte[] readSector35(int track, int sector) throws IllegalArgumentException {
        int block = track * 8 + ProdosOrder.blockInterleave[sector];
        byte[] blockData = this.readBlock(block);
        int offset = ProdosOrder.blockOffsets[sector];
        byte[] sectorData = new byte[256];
        System.arraycopy(blockData, offset * 256, sectorData, 0, 256);
        return sectorData;
    }

    @Override
    public void writeSector(int track, int sector, byte[] bytes) throws IllegalArgumentException {
        throw new RuntimeException("WOZ Disk Image does not support writing at this time");
    }

    private void readMetaChunk(byte[] data) {
        if (data.length > 0) {
            String meta = new String(data);
            for (String line : meta.split("\n")) {
                String[] parts = line.split("\t");
                if (parts.length != 2) continue;
                this.meta.put(parts[0], parts[1]);
            }
        }
    }

    private void readTmapChunk525(byte[] data) {
        ByteBuffer bb = ByteBuffer.wrap(data);
        while (bb.hasRemaining()) {
            byte[] chunk = new byte[4];
            bb.get(chunk);
            this.tmap.add(new TmapChunk(chunk));
        }
    }

    private void readTmapChunk35(byte[] data) {
        ByteBuffer bb = ByteBuffer.wrap(data);
        while (bb.hasRemaining()) {
            byte chunk = bb.get();
            this.tmap.add(new TmapChunk(chunk));
        }
    }

    private void readTrksChunk(byte[] data) {
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < 160; ++i) {
            this.trks.add(new TrkInfo(bb));
        }
    }

    protected byte[] readTrackData(int track) {
        return this.trackReader.apply(track);
    }

    protected byte[] readTrackDataWOZ2(int track) {
        TmapChunk map = this.tmap.get(track);
        int trkInfo = map.getOffset00();
        if (trkInfo == 255) {
            trkInfo = map.getOffset25();
        }
        if (trkInfo == 255) {
            trkInfo = map.getOffset50();
        }
        if (trkInfo == 255) {
            trkInfo = map.getOffset75();
        }
        TrkInfo trk = this.trks.get(trkInfo);
        byte[] rawData = this.readBytes(trk.getStartingBlock() * 512, trk.getBlockCount() * 512);
        return this.transformBitstream(rawData, trk.getBitCount());
    }

    protected byte[] readTrackDataWOZ1(int track) {
        int trackLength = 6656;
        int start = 256 + track * 6656;
        byte[] details = this.readBytes(start + 6646, 10);
        int bytesUsed = AppleUtil.getWordValue(details, 0);
        int bitCount = AppleUtil.getWordValue(details, 2);
        byte[] rawData = this.readBytes(start, bytesUsed);
        return this.transformBitstream(rawData, bitCount);
    }

    protected byte[] transformBitstream(byte[] rawData, int bitCount) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int bitNo = 7;
        int byteNo = 0;
        int byteVal = 0;
        while (bitCount > 0) {
            --bitCount;
            byteVal <<= 1;
            if (AppleUtil.isBitSet(rawData[byteNo], bitNo)) {
                byteVal |= 1;
            }
            if (--bitNo < 0) {
                bitNo = 7;
                ++byteNo;
            }
            if (byteVal < 128) continue;
            baos.write(byteVal);
            byteVal = 0;
        }
        return baos.toByteArray();
    }

    public static class TrkInfo {
        private int startingBlock;
        private int blockCount;
        private int bitCount;

        public TrkInfo(ByteBuffer bb) {
            this.startingBlock = bb.getShort();
            this.blockCount = bb.getShort();
            this.bitCount = bb.getInt();
        }

        public int getStartingBlock() {
            return this.startingBlock;
        }

        public int getBlockCount() {
            return this.blockCount;
        }

        public int getBitCount() {
            return this.bitCount;
        }
    }

    public static class TmapChunk {
        private byte[] tmap;

        public TmapChunk(byte[] data) {
            if (data.length != 4) {
                throw new RuntimeException("Unexpected TMAP chunk size of " + data.length);
            }
            this.tmap = data;
        }

        public TmapChunk(byte data) {
            this.tmap = new byte[4];
            this.tmap[0] = data;
            this.tmap[1] = -1;
            this.tmap[2] = -1;
            this.tmap[3] = -1;
        }

        public int getOffset00() {
            return Byte.toUnsignedInt(this.tmap[0]);
        }

        public int getOffset25() {
            return Byte.toUnsignedInt(this.tmap[1]);
        }

        public int getOffset50() {
            return Byte.toUnsignedInt(this.tmap[2]);
        }

        public int getOffset75() {
            return Byte.toUnsignedInt(this.tmap[3]);
        }
    }

    public static class InfoChunk {
        private int version;
        private int diskType;
        private int writeProtected;
        private int synchrinized;
        private int cleaned;
        private String creator;
        private int diskSides;
        private int bootSectorFormat;
        private int optimalBitTiming;
        private int compatibleHardware;
        private int requiredRAM;
        private int largestTrack;
        private int fluxBlock;
        private int largestFluxTrack;

        public InfoChunk(byte[] data) {
            ByteBuffer bb = ByteBuffer.wrap(data);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            this.version = bb.get();
            this.diskType = bb.get();
            this.writeProtected = bb.get();
            this.synchrinized = bb.get();
            this.cleaned = bb.get();
            byte[] creator = new byte[32];
            bb.get(creator);
            this.creator = new String(creator);
            if (this.version == 2) {
                this.diskSides = bb.get();
                this.bootSectorFormat = bb.get();
                this.optimalBitTiming = bb.get();
                this.compatibleHardware = bb.getShort();
                this.requiredRAM = bb.getShort();
                this.largestTrack = bb.getShort();
            }
            if (this.version == 3) {
                this.fluxBlock = bb.getShort();
                this.largestFluxTrack = bb.getShort();
            }
        }

        public int getVersion() {
            return this.version;
        }

        public int getDiskType() {
            return this.diskType;
        }

        public int getWriteProtected() {
            return this.writeProtected;
        }

        public int getSynchrinized() {
            return this.synchrinized;
        }

        public int getCleaned() {
            return this.cleaned;
        }

        public String getCreator() {
            return this.creator;
        }

        public int getDiskSides() {
            return this.diskSides;
        }

        public int getBootSectorFormat() {
            return this.bootSectorFormat;
        }

        public int getOptimalBitTiming() {
            return this.optimalBitTiming;
        }

        public int getCompatibleHardware() {
            return this.compatibleHardware;
        }

        public int getRequiredRAM() {
            return this.requiredRAM;
        }

        public int getLargestTrack() {
            return this.largestTrack;
        }

        public int getFluxBlock() {
            return this.fluxBlock;
        }

        public int getLargestFluxTrack() {
            return this.largestFluxTrack;
        }
    }
}

