/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.util;

import java.io.File;

public class Host {
    private static final boolean macOSX;
    private static final boolean linux;
    private static final boolean windows;
    private static final String userHome;
    private static final String osName;
    private static final String prefDir;

    private Host() {
    }

    public static String getPrefDir() {
        return prefDir;
    }

    public static String getFileName(String pathName) {
        if (macOSX) {
            File file = new File(pathName);
            return file.getName();
        }
        return pathName;
    }

    public static boolean isLinux() {
        return linux;
    }

    public static boolean isMacosx() {
        return macOSX;
    }

    public static boolean isWindows() {
        return windows;
    }

    static {
        userHome = System.getProperty("user.home");
        osName = System.getProperty("os.name");
        macOSX = osName.indexOf("Mac OS X") >= 0;
        linux = osName.indexOf("Linux") >= 0;
        boolean bl = windows = osName.indexOf("Windows") >= 0;
        prefDir = macOSX ? userHome + "/Library/Preferences/" : (linux ? userHome + "/." : (windows ? userHome : ""));
    }
}

