/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.util.filestreamer;

import com.webcodepro.applecommander.storage.Disk;
import com.webcodepro.applecommander.storage.DiskException;
import com.webcodepro.applecommander.storage.DiskUnrecognizedException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.util.filestreamer.FileTuple;
import com.webcodepro.applecommander.util.filestreamer.TypeOfFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class FileStreamer {
    private static final Consumer<FormattedDisk> NOOP_CONSUMER = d -> {};
    private FormattedDisk[] formattedDisks = null;
    private boolean ignoreErrorsFlag = false;
    private boolean recursiveFlag = true;
    private Consumer<FormattedDisk> beforeDisk = NOOP_CONSUMER;
    private Consumer<FormattedDisk> afterDisk = NOOP_CONSUMER;
    private Predicate<FileTuple> filters = this::deletedFileFilter;
    private boolean includeDeletedFlag = false;
    private List<PathMatcher> pathMatchers = new ArrayList<PathMatcher>();

    public static FileStreamer forDisk(File file) throws IOException, DiskUnrecognizedException {
        return FileStreamer.forDisk(file.getPath());
    }

    public static FileStreamer forDisk(String fileName) throws IOException, DiskUnrecognizedException {
        return new FileStreamer(new Disk(fileName));
    }

    public static FileStreamer forDisk(Disk disk) throws DiskUnrecognizedException {
        return new FileStreamer(disk);
    }

    public static FileStreamer forFormattedDisks(FormattedDisk ... disks) {
        return new FileStreamer(disks);
    }

    private FileStreamer(Disk disk) throws DiskUnrecognizedException {
        this(disk.getFormattedDisks());
    }

    private FileStreamer(FormattedDisk ... disks) {
        this.formattedDisks = disks;
    }

    public FileStreamer ignoreErrors(boolean flag) {
        this.ignoreErrorsFlag = flag;
        return this;
    }

    public FileStreamer recursive(boolean flag) {
        this.recursiveFlag = flag;
        return this;
    }

    public FileStreamer matchGlobs(List<String> globs) {
        if (globs != null && !globs.isEmpty()) {
            FileSystem fs = FileSystems.getDefault();
            for (String glob : globs) {
                this.pathMatchers.add(fs.getPathMatcher("glob:" + glob));
            }
            this.filters = this.filters.and(this::globFilter);
        }
        return this;
    }

    public FileStreamer matchGlobs(String ... globs) {
        return this.matchGlobs(Arrays.asList(globs));
    }

    public FileStreamer includeTypeOfFile(TypeOfFile type) {
        this.filters = this.filters.and(type.predicate);
        return this;
    }

    public FileStreamer includeDeleted(boolean flag) {
        this.includeDeletedFlag = flag;
        return this;
    }

    public FileStreamer beforeDisk(Consumer<FormattedDisk> consumer) {
        this.beforeDisk = consumer;
        return this;
    }

    public FileStreamer afterDisk(Consumer<FormattedDisk> consumer) {
        this.afterDisk = consumer;
        return this;
    }

    public Stream<FileTuple> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 0), false).filter(this.filters);
    }

    public Iterator<FileTuple> iterator() {
        return new FileTupleIterator();
    }

    protected boolean deletedFileFilter(FileTuple tuple) {
        return this.includeDeletedFlag || !tuple.fileEntry.isDeleted();
    }

    protected boolean globFilter(FileTuple tuple) {
        if (this.recursiveFlag && tuple.fileEntry.isDirectory()) {
            return true;
        }
        FileSystem fs = FileSystems.getDefault();
        Path filePath = Paths.get(tuple.fileEntry.getFilename(), new String[0]);
        Path fullPath = Paths.get(String.join((CharSequence)fs.getSeparator(), tuple.paths), tuple.fileEntry.getFilename());
        for (PathMatcher pathMatcher : this.pathMatchers) {
            if (!pathMatcher.matches(filePath) && !pathMatcher.matches(fullPath)) continue;
            return true;
        }
        return false;
    }

    private class FileTupleIterator
    implements Iterator<FileTuple> {
        private LinkedList<FileTuple> files = new LinkedList();
        private FormattedDisk currentDisk;

        private FileTupleIterator() {
            for (FormattedDisk formattedDisk : FileStreamer.this.formattedDisks) {
                this.files.add(FileTuple.of(formattedDisk));
            }
        }

        @Override
        public boolean hasNext() {
            boolean hasNext;
            boolean bl = hasNext = !this.files.isEmpty();
            if (hasNext) {
                FileTuple tuple = this.files.peek();
                if (tuple.formattedDisk != this.currentDisk) {
                    if (this.currentDisk != null) {
                        FileStreamer.this.afterDisk.accept(this.currentDisk);
                    }
                    this.currentDisk = tuple.formattedDisk;
                    FileStreamer.this.beforeDisk.accept(this.currentDisk);
                }
                if (tuple.isDisk()) {
                    tuple = this.files.removeFirst();
                    this.files.addAll(0, this.toTupleList(tuple));
                    return this.hasNext();
                }
            } else {
                if (this.currentDisk != null) {
                    FileStreamer.this.afterDisk.accept(this.currentDisk);
                }
                this.currentDisk = null;
            }
            return hasNext;
        }

        @Override
        public FileTuple next() {
            if (this.hasNext()) {
                FileTuple tuple = this.files.removeFirst();
                if (FileStreamer.this.recursiveFlag && tuple.isDirectory()) {
                    FileTuple newTuple = tuple.pushd(tuple.fileEntry);
                    this.files.addAll(0, this.toTupleList(newTuple));
                }
                return tuple;
            }
            throw new NoSuchElementException();
        }

        private List<FileTuple> toTupleList(FileTuple tuple) {
            ArrayList<FileTuple> list;
            block3: {
                list = new ArrayList<FileTuple>();
                try {
                    for (FileEntry fileEntry : tuple.directoryEntry.getFiles()) {
                        list.add(tuple.of(fileEntry));
                    }
                }
                catch (DiskException e) {
                    if (FileStreamer.this.ignoreErrorsFlag) break block3;
                    throw new RuntimeException(e);
                }
            }
            return list;
        }
    }
}

