/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.util.readerwriter;

import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.filters.PascalTextFileFilter;
import com.webcodepro.applecommander.storage.os.pascal.PascalFileEntry;
import com.webcodepro.applecommander.util.readerwriter.FileEntryReader;
import com.webcodepro.applecommander.util.readerwriter.FileEntryWriter;
import java.util.Date;
import java.util.Optional;

public class PascalFileEntryReaderWriter
implements FileEntryReader,
FileEntryWriter {
    private static final PascalTextFileFilter TEXT_FILTER = new PascalTextFileFilter();
    private PascalFileEntry fileEntry;

    public PascalFileEntryReaderWriter(PascalFileEntry fileEntry) {
        this.fileEntry = fileEntry;
    }

    @Override
    public Optional<String> getFilename() {
        return Optional.ofNullable(this.fileEntry.getFilename());
    }

    @Override
    public void setFilename(String filename) {
        this.fileEntry.setFilename(filename);
    }

    @Override
    public Optional<String> getProdosFiletype() {
        return Optional.ofNullable(this.fileEntry.getFormattedDisk().toProdosFiletype(this.fileEntry.getFiletype()));
    }

    @Override
    public void setProdosFiletype(String filetype) {
        this.fileEntry.setFiletype(this.fileEntry.getFormattedDisk().toNativeFiletype(filetype));
    }

    @Override
    public Optional<Date> getLastModificationDate() {
        return Optional.ofNullable(this.fileEntry.getModificationDate());
    }

    @Override
    public void setLastModificationDate(Date date) {
        this.fileEntry.setModificationDate(date);
    }

    @Override
    public Optional<byte[]> getFileData() {
        if ("TEXT".equals(this.fileEntry.getFiletype())) {
            return Optional.ofNullable(TEXT_FILTER.filter(this.fileEntry));
        }
        return Optional.ofNullable(this.fileEntry.getFileData());
    }

    @Override
    public void setFileData(byte[] data) {
        try {
            this.fileEntry.setFileData(data);
        }
        catch (DiskFullException e) {
            throw new RuntimeException(e);
        }
    }
}

