/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.filters;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import io.github.applecommander.disassembler.api.Disassembler;
import io.github.applecommander.disassembler.api.Instruction;
import io.github.applecommander.disassembler.api.InstructionSet;
import io.github.applecommander.disassembler.api.mos6502.InstructionSet6502;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.stream.Collectors;

public class DisassemblyFileFilter
implements FileFilter {
    @Override
    public byte[] filter(FileEntry fileEntry) {
        List instructions = Disassembler.with((byte[])fileEntry.getFileData()).startingAddress(fileEntry.getAddress()).use((InstructionSet)InstructionSet6502.for6502()).decode();
        String code = instructions.stream().map(this::emitRaw).collect(Collectors.joining());
        return code.getBytes();
    }

    @Override
    public String getSuggestedFileName(FileEntry fileEntry) {
        Object fileName = fileEntry.getFilename().trim();
        if (!((String)fileName).toLowerCase().endsWith(".asm")) {
            fileName = (String)fileName + ".asm";
        }
        return fileName;
    }

    public String emitRaw(Instruction instruction) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.printf("%04X- ", instruction.getAddress());
        byte[] code = instruction.getBytes();
        for (int i = 0; i < 3; ++i) {
            if (i >= code.length) {
                pw.printf("   ", new Object[0]);
                continue;
            }
            pw.printf("%02X ", code[i]);
        }
        pw.printf(" %s\n", instruction.formatOperandWithValue());
        return sw.toString();
    }
}

