/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.filters;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import io.github.applecommander.bastools.api.shapes.ShapeExporter;
import io.github.applecommander.bastools.api.shapes.ShapeTable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;

public class ShapeTableFileFilter
implements FileFilter {
    @Override
    public byte[] filter(FileEntry fileEntry) {
        try {
            ShapeTable shapeTable = ShapeTable.read((byte[])fileEntry.getFileData());
            ShapeExporter exporter = ShapeExporter.image().border(true).maxWidth(512).png().skipEmptyShapes(false).build();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            exporter.export(shapeTable, (OutputStream)outputStream);
            return outputStream.toByteArray();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public String getSuggestedFileName(FileEntry fileEntry) {
        Object fileName = fileEntry.getFilename().trim();
        if (!((String)fileName).toLowerCase().endsWith(".png")) {
            fileName = (String)fileName + ".png";
        }
        return fileName;
    }
}

