/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.filters.imagehandlers;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;

public abstract class AppleImage {
    private String fileExtension;
    private String[] availableExtensions;

    public static AppleImage create(int width, int height) {
        String[] classNames = new String[]{"ImageIoImage", "SunJpegImage", "SwtImage"};
        Class[] constructorArgClasses = new Class[]{Integer.TYPE, Integer.TYPE};
        Object[] constructorArgs = new Object[]{width, height};
        for (String className : classNames) {
            try {
                Class<?> appleImageClass = Class.forName("com.webcodepro.applecommander.storage.filters.imagehandlers." + className);
                Constructor<?> constructor = appleImageClass.getConstructor(constructorArgClasses);
                Object instance = constructor.newInstance(constructorArgs);
                return (AppleImage)AppleImage.class.cast(instance);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public AppleImage(String[] availableExtensions) {
        this.setAvailableExtensions(availableExtensions);
        this.setFileExtension(this.getDefaultExtension());
    }

    public String getDefaultExtension() {
        return this.getAvailableExtensions()[0];
    }

    public String[] getAvailableExtensions() {
        return this.availableExtensions;
    }

    protected void setAvailableExtensions(String[] availableExtensions) {
        this.availableExtensions = availableExtensions;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public abstract void setPoint(int var1, int var2, int var3);

    public abstract int getPoint(int var1, int var2);

    public abstract void save(OutputStream var1) throws IOException;

    public abstract int getWidth();

    public abstract int getHeight();
}

