/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.nakedos;

import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.filters.BinaryFileFilter;
import com.webcodepro.applecommander.storage.os.nakedos.NakedosFormatDisk;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class NakedosFileEntry
implements FileEntry {
    private TextBundle textBundle = StorageBundle.getInstance();
    private NakedosFormatDisk disk;
    private int fileNumber;
    private int size;

    public NakedosFileEntry(NakedosFormatDisk disk, int fileNumber, int size) {
        this.disk = disk;
        this.fileNumber = fileNumber;
        this.size = size;
    }

    @Override
    public String getFilename() {
        return AppleUtil.getFormattedByte(this.fileNumber);
    }

    public int getFileNumber() {
        return this.fileNumber;
    }

    @Override
    public void setFilename(String filename) {
    }

    @Override
    public String getFiletype() {
        return "B";
    }

    @Override
    public void setFiletype(String filetype) {
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    @Override
    public void setLocked(boolean lock) {
    }

    @Override
    public int getSize() {
        return this.size * 256;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public void delete() {
    }

    @Override
    public List<String> getFileColumnData(int displayMode) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        ArrayList<String> list = new ArrayList<String>();
        switch (displayMode) {
            case 2: {
                list.add(this.isLocked() ? "*" : " ");
                list.add(this.getFiletype());
                numberFormat.setMinimumIntegerDigits(3);
                list.add(numberFormat.format(this.getSize() / 256));
                list.add(this.getFilename());
                break;
            }
            case 3: {
                list.add(this.isLocked() ? "*" : " ");
                list.add(this.getFiletype());
                list.add(this.getFilename());
                list.add(numberFormat.format(this.getSize()));
                numberFormat.setMinimumIntegerDigits(3);
                list.add(numberFormat.format(this.getSize() / 256));
                list.add(this.isDeleted() ? this.textBundle.get("Deleted") : "");
                break;
            }
            default: {
                list.add(this.getFilename());
                list.add(this.getFiletype());
                list.add(numberFormat.format(this.getSize()));
                list.add(this.isLocked() ? this.textBundle.get("Locked") : "");
            }
        }
        return list;
    }

    @Override
    public byte[] getFileData() {
        return this.disk.getFileData(this);
    }

    @Override
    public void setFileData(byte[] data) throws DiskFullException {
        this.disk.setFileData(this, data);
    }

    @Override
    public FileFilter getSuggestedFilter() {
        return new BinaryFileFilter();
    }

    @Override
    public FormattedDisk getFormattedDisk() {
        return this.disk;
    }

    @Override
    public int getMaximumFilenameLength() {
        return 2;
    }

    @Override
    public boolean needsAddress() {
        return false;
    }

    @Override
    public void setAddress(int address) {
    }

    @Override
    public int getAddress() {
        return 0;
    }

    @Override
    public boolean canCompile() {
        return false;
    }

    public boolean equals(Object o) {
        return this.getFilename().equals(((NakedosFileEntry)o).getFilename());
    }
}

