/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.prodos;

import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFormatDisk;
import com.webcodepro.applecommander.util.AppleUtil;
import java.util.Date;

public class ProdosCommonEntry {
    public static final int ENTRY_LENGTH = 39;
    private ProdosFormatDisk disk;
    private int block;
    private int offset;

    public ProdosCommonEntry(ProdosFormatDisk disk, int block, int offset) {
        this.disk = disk;
        this.block = block;
        this.offset = offset;
    }

    protected int getFileEntryBlock() {
        return this.block;
    }

    protected ProdosFormatDisk getDisk() {
        return this.disk;
    }

    protected byte[] readFileEntry() {
        byte[] data = this.disk.readBlock(this.block);
        byte[] entry = new byte[39];
        System.arraycopy(data, this.offset, entry, 0, 39);
        return entry;
    }

    public boolean isEmpty() {
        byte[] entry = this.readFileEntry();
        for (int i = 0; i < entry.length; ++i) {
            if (entry[i] == 0) continue;
            return false;
        }
        return true;
    }

    protected void writeFileEntry(byte[] entry) {
        byte[] data = this.disk.readBlock(this.block);
        System.arraycopy(entry, 0, data, this.offset, 39);
        this.disk.writeBlock(this.block, data);
    }

    protected int getStorageType() {
        return AppleUtil.getUnsignedByte(this.readFileEntry()[0]) >> 4;
    }

    public void setStorageType(int storageType) {
        byte[] data = this.readFileEntry();
        int value = AppleUtil.getUnsignedByte(data[0]);
        value = value & 0xF | (storageType & 0xF) << 4;
        data[0] = (byte)value;
        this.writeFileEntry(data);
    }

    public boolean isSeedlingFile() {
        return this.getStorageType() == 1;
    }

    public void setSeedlingFile() {
        this.setStorageType(1);
    }

    public boolean isSaplingFile() {
        return this.getStorageType() == 2;
    }

    public void setSaplingFile() {
        this.setStorageType(2);
    }

    public boolean isTreeFile() {
        return this.getStorageType() == 3;
    }

    public void setTreeFile() {
        this.setStorageType(3);
    }

    public boolean isSubdirectory() {
        return this.getStorageType() == 13;
    }

    public void setSubdirectory() {
        this.setStorageType(13);
    }

    public boolean isSubdirectoryHeader() {
        return this.getStorageType() == 14;
    }

    public void setSubdirectoryHeader() {
        this.setStorageType(14);
    }

    public boolean isVolumeHeader() {
        return this.getStorageType() == 15;
    }

    public void setVolumeHeader() {
        this.setStorageType(15);
    }

    public Date getCreationDate() {
        return AppleUtil.getProdosDate(this.readFileEntry(), 24);
    }

    public void setCreationDate(Date date) {
        byte[] data = this.readFileEntry();
        AppleUtil.setProdosDate(data, 24, date);
        this.writeFileEntry(data);
    }

    public int getProdosVersion() {
        return AppleUtil.getUnsignedByte(this.readFileEntry()[28]);
    }

    public void setProdosVersion(int version) {
        byte[] data = this.readFileEntry();
        data[28] = (byte)version;
        this.writeFileEntry(data);
    }

    public int getMinimumProdosVersion() {
        return AppleUtil.getUnsignedByte(this.readFileEntry()[29]);
    }

    public void setMinimumProdosVersion(int version) {
        byte[] data = this.readFileEntry();
        data[29] = (byte)version;
        this.writeFileEntry(data);
    }

    protected byte getAccess() {
        return this.readFileEntry()[30];
    }

    protected void setAccess(int bit, boolean set) {
        byte[] data = this.readFileEntry();
        byte value = data[30];
        value = set ? AppleUtil.setBit(value, bit) : AppleUtil.clearBit(value, bit);
        data[30] = value;
        this.writeFileEntry(data);
    }

    public boolean canDestroy() {
        return AppleUtil.isBitSet(this.getAccess(), 7);
    }

    public void setCanDestroy(boolean destroy) {
        this.setAccess(7, destroy);
    }

    public boolean canRename() {
        return AppleUtil.isBitSet(this.getAccess(), 6);
    }

    public void setCanRename(boolean rename) {
        this.setAccess(6, rename);
    }

    public boolean hasChanged() {
        return AppleUtil.isBitSet(this.getAccess(), 5);
    }

    public void setHasChanged(boolean changed) {
        this.setAccess(5, changed);
    }

    public boolean canWrite() {
        return AppleUtil.isBitSet(this.getAccess(), 1);
    }

    public void setCanWrite(boolean write) {
        this.setAccess(1, write);
    }

    public boolean canRead() {
        return AppleUtil.isBitSet(this.getAccess(), 0);
    }

    public void setCanRead(boolean read) {
        this.setAccess(0, read);
    }

    public FormattedDisk getFormattedDisk() {
        return this.disk;
    }
}

