/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.rdos;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.DiskGeometry;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.os.rdos.RdosFileEntry;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.storage.physical.ProdosOrder;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;

public class RdosFormatDisk
extends FormattedDisk {
    private TextBundle textBundle = StorageBundle.getInstance();
    private static final int[] sectorSkew = new int[]{0, 7, 14, 6, 13, 5, 12, 4, 11, 3, 10, 2, 9, 1, 8, 15};
    public static final int ENTRY_LENGTH = 32;
    public static final int TRACKS_ON_DISK = 35;
    public static final int CATALOG_SECTORS = 10;
    public static final String[] FILE_TYPES = new String[]{"B", "A", "T"};
    private static final Map<String, String> FILE_TYPE_MAPPING = Map.of("T", "TXT", "A", "BAS", "B", "BIN");

    private int SectorsPerTrack() {
        if (this.getImageOrder() instanceof ProdosOrder) {
            return this.getImageOrder().getSectorsPerTrack();
        }
        return 13;
    }

    private int BlocksOnDisk() {
        return 35 * this.SectorsPerTrack();
    }

    public RdosFormatDisk(String filename, ImageOrder imageOrder) {
        super(filename, imageOrder);
    }

    public static RdosFormatDisk[] create(String filename, ImageOrder imageOrder) {
        RdosFormatDisk disk = new RdosFormatDisk(filename, imageOrder);
        disk.format();
        return new RdosFormatDisk[]{disk};
    }

    public byte[] readRdosBlock(int block) {
        int s = this.SectorsPerTrack();
        int track = block / s;
        int sector = block % s;
        if (s == 13) {
            sector = sectorSkew[sector];
        }
        return this.readSector(track, sector);
    }

    public void writeRdosBlock(int block, byte[] data) {
        int s = this.SectorsPerTrack();
        int track = block / s;
        int sector = block % s;
        if (s == 13) {
            sector = sectorSkew[sector];
        }
        this.writeSector(track, sector, data);
    }

    @Override
    public String getDiskName() {
        if (this.SectorsPerTrack() == 13) {
            byte[] block = this.readRdosBlock(4);
            return AppleUtil.getString(block, 224, 32);
        }
        byte[] block = this.readSector(1, 0);
        return AppleUtil.getString(block, 0, 24);
    }

    @Override
    public List<FileEntry> getFiles() {
        ArrayList<FileEntry> files = new ArrayList<FileEntry>();
        for (int b = 0; b < 10; ++b) {
            byte[] data = this.readRdosBlock(b + this.SectorsPerTrack());
            for (int i = 0; i < data.length; i += 32) {
                byte[] entry = new byte[32];
                System.arraycopy(data, i, entry, 0, entry.length);
                if (AppleUtil.getUnsignedByte(entry[0]) == 0) continue;
                RdosFileEntry fileEntry = new RdosFileEntry(entry, this);
                files.add(fileEntry);
            }
        }
        return files;
    }

    @Override
    public FileEntry createFile() throws DiskFullException {
        throw new DiskFullException(this.textBundle.get("FileCreationNotSupported"), this.getFilename());
    }

    @Override
    public boolean canCreateDirectories() {
        return false;
    }

    @Override
    public boolean canCreateFile() {
        return false;
    }

    @Override
    public String getFormat() {
        if (this.SectorsPerTrack() == 13) {
            return this.textBundle.get("RdosFormatDisk.Rdos21");
        }
        return this.textBundle.get("RdosFormatDisk.Rdos33");
    }

    public int getFreeBlocks() {
        return this.BlocksOnDisk() - this.getUsedBlocks();
    }

    public int getUsedBlocks() {
        int used = 0;
        for (FileEntry fileEntry : this.getFiles()) {
            RdosFileEntry entry = (RdosFileEntry)fileEntry;
            if (fileEntry.isDeleted()) continue;
            used += entry.getSizeInBlocks();
        }
        return used;
    }

    @Override
    public int getFreeSpace() {
        return this.getFreeBlocks() * 256;
    }

    @Override
    public int getUsedSpace() {
        return this.getUsedBlocks() * 256;
    }

    @Override
    public int[] getBitmapDimensions() {
        return null;
    }

    @Override
    public int getBitmapLength() {
        return this.BlocksOnDisk();
    }

    @Override
    public FormattedDisk.DiskUsage getDiskUsage() {
        return new RdosDiskUsage();
    }

    @Override
    public String[] getBitmapLabels() {
        return new String[]{this.textBundle.get("Block")};
    }

    @Override
    public List<FormattedDisk.DiskInformation> getDiskInformation() {
        List<FormattedDisk.DiskInformation> list = super.getDiskInformation();
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("TotalBlocks"), this.BlocksOnDisk()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("FreeBlocks"), this.getFreeBlocks()));
        list.add((FormattedDisk)this.new FormattedDisk.DiskInformation(this.textBundle.get("UsedBlocks"), this.getUsedBlocks()));
        return list;
    }

    @Override
    public List<FormattedDisk.FileColumnHeader> getFileColumnHeaders(int displayMode) {
        ArrayList<FormattedDisk.FileColumnHeader> list = new ArrayList<FormattedDisk.FileColumnHeader>();
        switch (displayMode) {
            case 2: {
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Type"), 1, 2, "type"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Blocks"), 3, 3, "blocks"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 24, 1, "name"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("RdosFormatDisk.Size"), 6, 3, "size"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("RdosFormatDisk.StartingBlock"), 3, 3, "firstBlock"));
                break;
            }
            case 3: {
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Type"), 1, 2, "type"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Blocks"), 3, 3, "blocks"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 24, 1, "name"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("RdosFormatDisk.Size"), 6, 3, "size"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("RdosFormatDisk.StartingBlock"), 3, 3, "firstBlock"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("RdosFormatDisk.Address"), 5, 3, "address"));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DeletedQ"), 7, 2, "deleted"));
                break;
            }
            default: {
                list.addAll(super.getFileColumnHeaders(displayMode));
            }
        }
        return list;
    }

    @Override
    public boolean supportsDeletedFiles() {
        return true;
    }

    @Override
    public boolean canReadFileData() {
        return true;
    }

    @Override
    public boolean canWriteFileData() {
        return false;
    }

    @Override
    public boolean canHaveDirectories() {
        return false;
    }

    @Override
    public boolean canDeleteFile() {
        return false;
    }

    @Override
    public byte[] getFileData(FileEntry fileEntry) {
        if (!(fileEntry instanceof RdosFileEntry)) {
            throw new IllegalArgumentException(this.textBundle.get("RdosFormatDisk.IncorrectFileEntryError"));
        }
        RdosFileEntry rdosEntry = (RdosFileEntry)fileEntry;
        int startingBlock = rdosEntry.getStartingBlock();
        byte[] fileData = new byte[rdosEntry.getSizeInBlocks() * 256];
        int offset = 0;
        for (int blockOffset = 0; blockOffset < rdosEntry.getSizeInBlocks(); ++blockOffset) {
            byte[] blockData = this.readRdosBlock(startingBlock + blockOffset);
            System.arraycopy(blockData, 0, fileData, offset, blockData.length);
            offset += blockData.length;
        }
        return fileData;
    }

    @Override
    public void format() {
        this.getImageOrder().format();
        this.writeBootCode();
        byte[] block = this.readSector(0, 13);
        AppleUtil.setString(block, 224, this.textBundle.get("RdosFormatDisk.IdentifierText"), 32);
        this.writeSector(0, 13, block);
        block = new byte[256];
        block[0] = 96;
        this.writeSector(1, 9, block);
        byte[] data = this.readRdosBlock(13);
        AppleUtil.setString(data, 0, this.textBundle.get("RdosFormatDisk.InitialSystemFile"), 24);
        AppleUtil.setString(data, 24, "B", 1);
        data[25] = 26;
        AppleUtil.setWordValue(data, 26, 4096);
        AppleUtil.setWordValue(data, 28, 6656);
        AppleUtil.setWordValue(data, 30, 0);
        this.writeRdosBlock(13, data);
    }

    @Override
    public int getLogicalDiskNumber() {
        return 0;
    }

    @Override
    public String getSuggestedFilename(String filename) {
        int len = Math.min(filename.length(), 24);
        return filename.toUpperCase().substring(0, len).trim();
    }

    @Override
    public String getSuggestedFiletype(String filename) {
        String what;
        String filetype = "B";
        int pos = filename.lastIndexOf(".");
        if (pos > 0 && "txt".equalsIgnoreCase(what = filename.substring(pos + 1))) {
            filetype = "T";
        }
        return filetype;
    }

    @Override
    public String[] getFiletypes() {
        return FILE_TYPES;
    }

    @Override
    public boolean needsAddress(String filetype) {
        return "B".equals(filetype);
    }

    @Override
    public boolean supportsDiskMap() {
        return true;
    }

    @Override
    public void changeImageOrder(ImageOrder imageOrder) {
        AppleUtil.changeImageOrderByTrackAndSector(this.getImageOrder(), imageOrder);
        this.setImageOrder(imageOrder);
    }

    @Override
    public void setFileData(FileEntry fileEntry, byte[] fileData) throws DiskFullException {
    }

    @Override
    public DirectoryEntry createDirectory(String name) throws DiskFullException {
        throw new UnsupportedOperationException(this.textBundle.get("DirectoryCreationNotSupported"));
    }

    @Override
    public DiskGeometry getDiskGeometry() {
        return DiskGeometry.TRACK_SECTOR;
    }

    @Override
    public String fromProdosFiletype(String prodosFiletype) {
        return FILE_TYPE_MAPPING.entrySet().stream().filter(e -> ((String)e.getValue()).equals(prodosFiletype)).map(Map.Entry::getKey).findFirst().orElse("B");
    }

    @Override
    public String toProdosFiletype(String nativeFiletype) {
        return FILE_TYPE_MAPPING.getOrDefault(nativeFiletype, "BIN");
    }

    private class RdosDiskUsage
    implements FormattedDisk.DiskUsage {
        private int location = -1;
        private BitSet bitmap = null;

        private RdosDiskUsage() {
        }

        @Override
        public boolean hasNext() {
            return this.location == -1 || this.location < RdosFormatDisk.this.BlocksOnDisk() - 1;
        }

        @Override
        public void next() {
            if (this.bitmap == null) {
                this.bitmap = new BitSet(RdosFormatDisk.this.BlocksOnDisk());
                for (int b = 0; b < RdosFormatDisk.this.BlocksOnDisk(); ++b) {
                    this.bitmap.set(b);
                }
                for (FileEntry fileEntry : RdosFormatDisk.this.getFiles()) {
                    if (fileEntry.isDeleted()) continue;
                    RdosFileEntry entry = (RdosFileEntry)fileEntry;
                    for (int b = 0; b < entry.getSizeInBlocks(); ++b) {
                        this.bitmap.clear(entry.getStartingBlock() + b);
                    }
                }
                this.location = 0;
            } else {
                ++this.location;
            }
        }

        @Override
        public boolean isFree() {
            return this.bitmap.get(this.location);
        }

        @Override
        public boolean isUsed() {
            return !this.bitmap.get(this.location);
        }
    }
}

