/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.webcodepro.applecommander.storage.Disk;
import com.webcodepro.applecommander.storage.DiskUnrecognizedException;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.util.TextBundle;
import com.webcodepro.applecommander.util.filestreamer.FileStreamer;
import com.webcodepro.applecommander.util.filestreamer.FileTuple;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class DirectoryLister {
    private static TextBundle textBundle = UiBundle.getInstance();
    private ListingStrategy strategy;

    public static DirectoryLister text(int display) {
        return new DirectoryLister(new TextListingStrategy(display));
    }

    public static DirectoryLister csv(int display) {
        return new DirectoryLister(new CsvListingStrategy(display));
    }

    public static DirectoryLister json(int display) {
        return new DirectoryLister(new JsonListingStrategy(display));
    }

    private DirectoryLister(ListingStrategy strategy) {
        this.strategy = strategy;
    }

    public void list(String filename) throws DiskUnrecognizedException, IOException {
        Disk disk = new Disk(filename);
        this.strategy.first(disk);
        FileStreamer.forDisk(disk).recursive(true).includeDeleted(false).beforeDisk(this.strategy::beforeDisk).afterDisk(this.strategy::afterDisk).stream().forEach(this.strategy::forEach);
        this.strategy.last(disk);
    }

    public static class JsonListingStrategy
    extends ListingStrategy {
        private JsonObject root;
        private JsonArray disks;
        private JsonObject currentDisk;
        private JsonArray files;
        private Gson gson = new Gson();

        public JsonListingStrategy(int display) {
            super(display);
        }

        @Override
        public void first(Disk disk) {
            this.root = new JsonObject();
            this.root.addProperty("filename", disk.getFilename());
            this.root.addProperty("order", disk.getOrderName());
            this.root.addProperty("physicalSize", (Number)disk.getPhysicalSize());
            this.disks = new JsonArray();
            this.root.add("disks", (JsonElement)this.disks);
        }

        @Override
        public void beforeDisk(FormattedDisk disk) {
            this.currentDisk = new JsonObject();
            this.disks.add((JsonElement)this.currentDisk);
            this.currentDisk.addProperty("diskName", disk.getDiskName());
            this.currentDisk.addProperty("format", disk.getFormat());
            this.currentDisk.addProperty("freeSpace", (Number)disk.getFreeSpace());
            this.currentDisk.addProperty("usedSpace", (Number)disk.getUsedSpace());
            this.currentDisk.addProperty("logicalDiskNumber", (Number)disk.getLogicalDiskNumber());
            this.files = new JsonArray();
            this.currentDisk.add("files", (JsonElement)this.files);
        }

        @Override
        public void afterDisk(FormattedDisk disk) {
            this.currentDisk = null;
        }

        @Override
        public void forEach(FileTuple tuple) {
            JsonObject file = new JsonObject();
            this.files.add((JsonElement)file);
            List<FormattedDisk.FileColumnHeader> headers = tuple.formattedDisk.getFileColumnHeaders(this.display);
            List<String> columns = tuple.fileEntry.getFileColumnData(this.display);
            for (int i = 0; i < headers.size(); ++i) {
                file.addProperty(headers.get(i).getKey(), columns.get(i));
            }
        }

        @Override
        public void last(Disk disk) {
            System.out.println(this.gson.toJson((JsonElement)this.root));
        }
    }

    public static class CsvListingStrategy
    extends ListingStrategy {
        private CSVPrinter printer;

        public CsvListingStrategy(int display) {
            super(display);
            try {
                this.printer = new CSVPrinter((Appendable)System.out, CSVFormat.DEFAULT);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void beforeDisk(FormattedDisk disk) {
            try {
                this.printer.printRecord(new Object[]{disk.getFilename(), disk.getDiskName()});
                this.printer.printRecord((Iterable)disk.getFileColumnHeaders(this.display).stream().map(FormattedDisk.FileColumnHeader::getTitle).collect(Collectors.toList()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void afterDisk(FormattedDisk disk) {
            try {
                this.printer.printRecord(new Object[]{disk.getFormat(), disk.getFreeSpace(), disk.getUsedSpace()});
                this.printer.println();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void forEach(FileTuple tuple) {
            try {
                this.printer.printRecord(tuple.fileEntry.getFileColumnData(this.display));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class TextListingStrategy
    extends ListingStrategy {
        protected TextListingStrategy(int display) {
            super(display);
        }

        @Override
        public void beforeDisk(FormattedDisk disk) {
            System.out.printf("%s %s\n", disk.getFilename(), disk.getDiskName());
        }

        @Override
        public void afterDisk(FormattedDisk disk) {
            System.out.printf("%s\n\n", textBundle.format("CommandLineStatus", disk.getFormat(), disk.getFreeSpace(), disk.getUsedSpace()));
        }

        @Override
        public void forEach(FileTuple tuple) {
            System.out.printf("%s%s\n", this.repeat(" ", tuple.paths.size()), String.join((CharSequence)" ", tuple.fileEntry.getFileColumnData(this.display)));
        }

        private String repeat(String s, int n) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                sb.append(s);
            }
            return sb.toString();
        }
    }

    public static abstract class ListingStrategy {
        protected int display;

        protected ListingStrategy(int display) {
            this.display = display;
        }

        public void first(Disk d) {
        }

        public void beforeDisk(FormattedDisk d) {
        }

        public void afterDisk(FormattedDisk d) {
        }

        public void forEach(FileTuple f) {
        }

        public void last(Disk d) {
        }
    }
}

