/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.util;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.ApplesoftToken;

public class ApplesoftTokenizer {
    private static String[] tokens = new String[]{" END ", " FOR ", " NEXT ", " DATA ", " INPUT ", " DEL ", " DIM ", " READ ", " GR ", " TEXT ", " PR# ", " IN# ", " CALL ", " PLOT ", " HLIN ", " VLIN ", " HGR2 ", " HGR ", " HCOLOR= ", " HPLOT ", " DRAW ", " XDRAW ", " HTAB ", " HOME ", " ROT= ", " SCALE= ", " SHLOAD ", " TRACE ", " NOTRACE ", " NORMAL ", " INVERSE ", " FLASH ", " COLOR= ", " POP ", " VTAB ", " HIMEM: ", " LOMEM: ", " ONERR ", " RESUME ", " RECALL ", " STORE ", " SPEED= ", " LET ", " GOTO ", " RUN ", " IF ", " RESTORE ", " & ", " GOSUB ", " RETURN ", " REM ", " STOP ", " ON ", " WAIT ", " LOAD ", " SAVE ", " DEF ", " POKE ", " PRINT ", " CONT ", " LIST ", " CLEAR ", " GET ", " NEW ", " TAB( ", " TO ", " FN ", " SPC( ", "  THEN ", " AT ", "  NOT ", "  STEP ", " +", " -", " *", "/", " ^", "  AND ", "  OR ", " >", " = ", " <", " SGN", " INT", " ABS", " USR", " FRE", " SCRN( ", " PDL", " POS", " SQR", " RND", " LOG", " EXP", " COS", " SIN", " TAN", " ATN", " PEEK", " LEN", " STR$", " VAL", " ASC", " CHR$", " LEFT$", " RIGHT$", " MID$ "};
    private byte[] fileData;
    private int offset;
    private int nextAddress = -1;

    public ApplesoftTokenizer(FileEntry fileEntry) {
        this(fileEntry.getFileData());
    }

    public ApplesoftTokenizer(byte[] fileData) {
        this.fileData = fileData;
    }

    public boolean hasMoreTokens() {
        return this.offset < this.fileData.length;
    }

    public ApplesoftToken getNextToken() {
        if (this.hasMoreTokens()) {
            byte byt;
            if (this.nextAddress == -1) {
                this.nextAddress = AppleUtil.getWordValue(this.fileData, this.offset);
                this.offset += 2;
                if (this.nextAddress == 0) {
                    this.offset = this.fileData.length;
                    return null;
                }
                int lineNumber = AppleUtil.getWordValue(this.fileData, this.offset);
                this.offset += 2;
                return new ApplesoftToken(lineNumber);
            }
            if ((byt = this.fileData[this.offset++]) == 0) {
                this.nextAddress = -1;
                return this.getNextToken();
            }
            if ((byt & 0x80) != 0) {
                int token = AppleUtil.getUnsignedByte(byt) - 128;
                if (token >= tokens.length) {
                    return new ApplesoftToken(byt, "<UNKNOWN TOKEN>");
                }
                return new ApplesoftToken(byt, tokens[token]);
            }
            if (byt == 58 || byt == 59 || byt == 44 || byt == 94 || byt == 43 || byt == 45 || byt == 42 || byt == 47) {
                return new ApplesoftToken(new String(new byte[]{byt}));
            }
            StringBuffer string = new StringBuffer();
            while (true) {
                char ch;
                if ((ch = (char)byt) < ' ') {
                    string.append("<CTRL-");
                    string.append((char)(64 + ch));
                    string.append('>');
                } else {
                    string.append(ch);
                }
                byt = this.fileData[this.offset];
                if ((byt & 0x80) != 0 || byt == 0 || byt == 58 || byt == 44 || byt == 59) break;
                ++this.offset;
            }
            return new ApplesoftToken(string.toString());
        }
        return null;
    }
}

