/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.util;

import java.text.MessageFormat;
import java.util.ResourceBundle;

public class TextBundle {
    private ResourceBundle resourceBundle;
    private static TextBundle instance;

    protected TextBundle() {
    }

    public static TextBundle getInstance() {
        if (instance == null) {
            instance = new TextBundle();
            instance.initialize();
        }
        return instance;
    }

    protected void initialize() {
        if (this.resourceBundle == null) {
            this.resourceBundle = ResourceBundle.getBundle(this.getClass().getName());
        }
    }

    public String get(String name) {
        if (this.resourceBundle.containsKey(name)) {
            return this.resourceBundle.getString(name);
        }
        return String.format("KeyNotFound: %s", name);
    }

    public String format(String name, Object ... values) {
        String resourceValue = this.get(name);
        MessageFormat messageFormat = new MessageFormat(resourceValue);
        return messageFormat.format(values);
    }
}

