/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.util.filestreamer;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FormattedDisk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class FileTuple {
    public static final String SEPARATOR = "/";
    private static final Logger LOG = Logger.getLogger(FileTuple.class.getName());
    public final FormattedDisk formattedDisk;
    public final List<String> paths;
    public final DirectoryEntry directoryEntry;
    public final FileEntry fileEntry;

    private FileTuple(FormattedDisk formattedDisk, List<String> paths, DirectoryEntry directoryEntry, FileEntry fileEntry) {
        this.formattedDisk = formattedDisk;
        this.paths = Collections.unmodifiableList(paths);
        this.directoryEntry = directoryEntry;
        this.fileEntry = fileEntry;
    }

    public FileTuple pushd(FileEntry directoryEntry) {
        LOG.fine("Adding directory " + directoryEntry.getFilename());
        ArrayList<String> newPaths = new ArrayList<String>(this.paths);
        newPaths.add(directoryEntry.getFilename());
        return new FileTuple(this.formattedDisk, newPaths, (DirectoryEntry)((Object)directoryEntry), null);
    }

    public boolean isDisk() {
        return this.fileEntry == null && (this.directoryEntry == null || this.directoryEntry == this.formattedDisk);
    }

    public boolean isDirectory() {
        return !this.isDisk() && (this.fileEntry == null || this.fileEntry.isDirectory());
    }

    public boolean isFile() {
        return this.fileEntry != null && !this.fileEntry.isDirectory();
    }

    public FileTuple of(FileEntry fileEntry) {
        return new FileTuple(this.formattedDisk, this.paths, this.directoryEntry, fileEntry);
    }

    public String fullPath() {
        return String.join((CharSequence)SEPARATOR, String.join((CharSequence)SEPARATOR, this.paths), this.fileEntry.getFilename());
    }

    public static FileTuple of(FormattedDisk disk) {
        return new FileTuple(disk, new ArrayList<String>(), disk, null);
    }
}

