/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.util.readerwriter;

import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.os.dos33.DosFileEntry;
import com.webcodepro.applecommander.storage.os.dos33.DosFormatDisk;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.readerwriter.FileEntryReader;
import com.webcodepro.applecommander.util.readerwriter.FileEntryWriter;
import java.util.Optional;

public class DosFileEntryReaderWriter
implements FileEntryReader,
FileEntryWriter {
    private DosFileEntry fileEntry;

    public DosFileEntryReaderWriter(DosFileEntry fileEntry) {
        if (fileEntry.isDeleted()) {
            throw new RuntimeException("Unable to copy deleted files.");
        }
        this.fileEntry = fileEntry;
    }

    @Override
    public Optional<String> getFilename() {
        return Optional.of(this.fileEntry.getFilename());
    }

    @Override
    public void setFilename(String filename) {
        this.fileEntry.setFilename(filename);
    }

    @Override
    public Optional<String> getProdosFiletype() {
        String prodosFiletype = this.fileEntry.getFormattedDisk().toProdosFiletype(this.fileEntry.getFiletype());
        return Optional.ofNullable(prodosFiletype);
    }

    @Override
    public void setProdosFiletype(String filetype) {
        String dosFiletype = this.fileEntry.getFormattedDisk().fromProdosFiletype(filetype);
        this.fileEntry.setFiletype(dosFiletype);
    }

    @Override
    public Optional<Boolean> isLocked() {
        return Optional.of(this.fileEntry.isLocked());
    }

    @Override
    public void setLocked(boolean flag) {
        this.fileEntry.setLocked(flag);
    }

    @Override
    public Optional<byte[]> getFileData() {
        return Optional.ofNullable(this.fileEntry.getFileData());
    }

    @Override
    public void setFileData(byte[] data) {
        try {
            this.fileEntry.setFileData(data);
        }
        catch (DiskFullException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Optional<Integer> getBinaryAddress() {
        if (this.fileEntry.isBinaryFile()) {
            byte[] rawdata = this.getRawFileData();
            return Optional.of(AppleUtil.getWordValue(rawdata, 0));
        }
        return Optional.empty();
    }

    @Override
    public void setBinaryAddress(int address) {
        if (this.fileEntry.needsAddress()) {
            this.fileEntry.setAddress(address);
        }
    }

    @Override
    public Optional<Integer> getBinaryLength() {
        if (this.fileEntry.isBinaryFile() || this.fileEntry.isApplesoftBasicFile() || this.fileEntry.isIntegerBasicFile()) {
            return Optional.of(this.fileEntry.getSize());
        }
        return Optional.empty();
    }

    @Override
    public void setBinaryLength(int length) {
    }

    private byte[] getRawFileData() {
        DosFormatDisk disk = (DosFormatDisk)this.fileEntry.getFormattedDisk();
        return disk.getFileData(this.fileEntry);
    }
}

