/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.util.readerwriter;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.os.dos33.DosFileEntry;
import com.webcodepro.applecommander.storage.os.nakedos.NakedosFileEntry;
import com.webcodepro.applecommander.storage.os.pascal.PascalFileEntry;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFileEntry;
import com.webcodepro.applecommander.storage.os.rdos.RdosFileEntry;
import com.webcodepro.applecommander.util.readerwriter.DosFileEntryReaderWriter;
import com.webcodepro.applecommander.util.readerwriter.NakedosFileEntryReader;
import com.webcodepro.applecommander.util.readerwriter.PascalFileEntryReaderWriter;
import com.webcodepro.applecommander.util.readerwriter.ProdosFileEntryReaderWriter;
import com.webcodepro.applecommander.util.readerwriter.RdosFileEntryReader;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;

public interface FileEntryReader {
    default public Optional<String> getFilename() {
        return Optional.empty();
    }

    default public Optional<String> getProdosFiletype() {
        return Optional.empty();
    }

    default public Optional<Boolean> isLocked() {
        return Optional.empty();
    }

    default public Optional<byte[]> getFileData() {
        return Optional.empty();
    }

    default public Optional<byte[]> getResourceData() {
        return Optional.empty();
    }

    default public Optional<Integer> getBinaryAddress() {
        return Optional.empty();
    }

    default public Optional<Integer> getBinaryLength() {
        return Optional.empty();
    }

    default public Optional<Integer> getAuxiliaryType() {
        return Optional.empty();
    }

    default public Optional<Date> getCreationDate() {
        return Optional.empty();
    }

    default public Optional<Date> getLastModificationDate() {
        return Optional.empty();
    }

    default public boolean equals(FileEntryReader reader) {
        return this.getFilename().equals(reader.getFilename()) && this.getProdosFiletype().equals(reader.getProdosFiletype()) && this.isLocked().equals(reader.isLocked()) && Arrays.equals(this.getFileData().orElse(null), reader.getFileData().orElse(null)) && Arrays.equals(this.getResourceData().orElse(null), reader.getResourceData().orElse(null)) && this.getBinaryAddress().equals(reader.getBinaryAddress()) && this.getBinaryLength().equals(reader.getBinaryLength()) && this.getAuxiliaryType().equals(reader.getAuxiliaryType()) && this.getCreationDate().equals(reader.getCreationDate()) && this.getLastModificationDate().equals(reader.getLastModificationDate());
    }

    public static FileEntryReader get(FileEntry fileEntry) {
        if (fileEntry instanceof DosFileEntry) {
            return new DosFileEntryReaderWriter((DosFileEntry)fileEntry);
        }
        if (fileEntry instanceof NakedosFileEntry) {
            return new NakedosFileEntryReader((NakedosFileEntry)fileEntry);
        }
        if (fileEntry instanceof PascalFileEntry) {
            return new PascalFileEntryReaderWriter((PascalFileEntry)fileEntry);
        }
        if (fileEntry instanceof ProdosFileEntry) {
            return new ProdosFileEntryReaderWriter((ProdosFileEntry)fileEntry);
        }
        if (fileEntry instanceof RdosFileEntry) {
            return new RdosFileEntryReader((RdosFileEntry)fileEntry);
        }
        throw new RuntimeException(String.format("No reader for %s", fileEntry.getClass().getName()));
    }
}

