/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.util.readerwriter;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.os.dos33.DosFileEntry;
import com.webcodepro.applecommander.storage.os.pascal.PascalFileEntry;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFileEntry;
import com.webcodepro.applecommander.util.readerwriter.DosFileEntryReaderWriter;
import com.webcodepro.applecommander.util.readerwriter.PascalFileEntryReaderWriter;
import com.webcodepro.applecommander.util.readerwriter.ProdosFileEntryReaderWriter;
import java.util.Date;

public interface FileEntryWriter {
    default public void setFilename(String filename) {
    }

    default public void setProdosFiletype(String filetype) {
    }

    default public void setLocked(boolean flag) {
    }

    default public void setFileData(byte[] data) {
    }

    default public void setFileData(byte[] data, byte[] resource) {
    }

    default public void setBinaryAddress(int address) {
    }

    default public void setBinaryLength(int length) {
    }

    default public void setAuxiliaryType(int auxType) {
    }

    default public void setCreationDate(Date date) {
    }

    default public void setLastModificationDate(Date date) {
    }

    public static FileEntryWriter get(FileEntry fileEntry) {
        if (fileEntry instanceof DosFileEntry) {
            return new DosFileEntryReaderWriter((DosFileEntry)fileEntry);
        }
        if (fileEntry instanceof ProdosFileEntry) {
            return new ProdosFileEntryReaderWriter((ProdosFileEntry)fileEntry);
        }
        if (fileEntry instanceof PascalFileEntry) {
            return new PascalFileEntryReaderWriter((PascalFileEntry)fileEntry);
        }
        throw new RuntimeException(String.format("No writer for %s", fileEntry.getClass().getName()));
    }
}

