/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.util.readerwriter;

import com.webcodepro.applecommander.util.readerwriter.FileEntryReader;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class OverrideFileEntryReader
implements FileEntryReader {
    private Optional<FileEntryReader> parent = Optional.empty();
    private Optional<String> filename = Optional.empty();
    private Optional<String> prodosFiletype = Optional.empty();
    private Optional<Boolean> locked = Optional.empty();
    private Optional<byte[]> fileData = Optional.empty();
    private Optional<byte[]> resourceData = Optional.empty();
    private Optional<Integer> binaryAddress = Optional.empty();
    private Optional<Integer> binaryLength = Optional.empty();
    private Optional<Integer> auxiliaryType = Optional.empty();
    private Optional<Date> creationDate = Optional.empty();
    private Optional<Date> lastModificationDate = Optional.empty();

    @Override
    public Optional<String> getFilename() {
        return this.filename.or(() -> this.parent.map(FileEntryReader::getFilename).filter(Optional::isPresent).map(Optional::get));
    }

    @Override
    public Optional<String> getProdosFiletype() {
        return this.prodosFiletype.or(() -> this.parent.map(FileEntryReader::getProdosFiletype).filter(Optional::isPresent).map(Optional::get));
    }

    @Override
    public Optional<Boolean> isLocked() {
        return this.locked.or(() -> this.parent.map(FileEntryReader::isLocked).filter(Optional::isPresent).map(Optional::get));
    }

    @Override
    public Optional<byte[]> getFileData() {
        return this.fileData.or(() -> this.parent.map(FileEntryReader::getFileData).filter(Optional::isPresent).map(Optional::get));
    }

    @Override
    public Optional<byte[]> getResourceData() {
        return this.resourceData;
    }

    @Override
    public Optional<Integer> getBinaryAddress() {
        return this.binaryAddress.or(() -> this.parent.map(FileEntryReader::getBinaryAddress).filter(Optional::isPresent).map(Optional::get));
    }

    @Override
    public Optional<Integer> getBinaryLength() {
        return this.binaryLength.or(() -> this.parent.map(FileEntryReader::getBinaryLength).filter(Optional::isPresent).map(Optional::get));
    }

    @Override
    public Optional<Integer> getAuxiliaryType() {
        return this.auxiliaryType.or(() -> this.parent.map(FileEntryReader::getBinaryLength).filter(Optional::isPresent).map(Optional::get));
    }

    @Override
    public Optional<Date> getCreationDate() {
        return this.creationDate.or(() -> this.parent.map(FileEntryReader::getCreationDate).filter(Optional::isPresent).map(Optional::get));
    }

    @Override
    public Optional<Date> getLastModificationDate() {
        return this.lastModificationDate.or(() -> this.parent.map(FileEntryReader::getLastModificationDate).filter(Optional::isPresent).map(Optional::get));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private OverrideFileEntryReader fileEntryReader = new OverrideFileEntryReader();

        public FileEntryReader build(FileEntryReader parent) {
            Objects.requireNonNull(parent);
            this.fileEntryReader.parent = Optional.of(parent);
            return this.fileEntryReader;
        }

        public List<FileEntryReader> buildList(FileEntryReader parent) {
            return Arrays.asList(this.build(parent));
        }

        public FileEntryReader build() {
            return this.fileEntryReader;
        }

        public List<FileEntryReader> buildList() {
            return Arrays.asList(this.build());
        }

        public Builder filename(String filename) {
            Objects.requireNonNull(filename);
            this.fileEntryReader.filename = Optional.of(filename);
            return this;
        }

        public Builder filename(Optional<String> filename) {
            Objects.requireNonNull(filename);
            this.fileEntryReader.filename = filename;
            return this;
        }

        public Builder prodosFiletype(String filetype) {
            Objects.requireNonNull(filetype);
            this.fileEntryReader.prodosFiletype = Optional.of(filetype);
            return this;
        }

        public Builder prodosFiletype(Optional<String> filetype) {
            Objects.requireNonNull(filetype);
            this.fileEntryReader.prodosFiletype = filetype;
            return this;
        }

        public Builder locked(boolean locked) {
            this.fileEntryReader.locked = Optional.of(locked);
            return this;
        }

        public Builder locked(Optional<Boolean> locked) {
            Objects.requireNonNull(locked);
            this.fileEntryReader.locked = locked;
            return this;
        }

        public Builder fileData(byte[] fileData) {
            Objects.requireNonNull(fileData);
            this.fileEntryReader.fileData = Optional.of(fileData);
            return this;
        }

        public Builder fileData(Optional<byte[]> fileData) {
            Objects.requireNonNull(fileData);
            this.fileEntryReader.fileData = fileData;
            return this;
        }

        public Builder resourceData(byte[] resourceData) {
            Objects.requireNonNull(resourceData);
            this.fileEntryReader.resourceData = Optional.of(resourceData);
            return this;
        }

        public Builder resourceData(Optional<byte[]> resourceData) {
            Objects.requireNonNull(resourceData);
            this.fileEntryReader.resourceData = resourceData;
            return this;
        }

        public Builder binaryAddress(int binaryAddress) {
            this.fileEntryReader.binaryAddress = Optional.of(binaryAddress);
            return this;
        }

        public Builder binaryAddress(Optional<Integer> binaryAddress) {
            Objects.requireNonNull(binaryAddress);
            this.fileEntryReader.binaryAddress = binaryAddress;
            return this;
        }

        public Builder binaryLength(int binaryLength) {
            this.fileEntryReader.binaryLength = Optional.of(binaryLength);
            return this;
        }

        public Builder binaryLength(Optional<Integer> binaryLength) {
            Objects.requireNonNull(binaryLength);
            this.fileEntryReader.binaryLength = binaryLength;
            return this;
        }

        public Builder auxiliaryType(int auxiliaryType) {
            this.fileEntryReader.auxiliaryType = Optional.of(auxiliaryType);
            return this;
        }

        public Builder auxiliaryType(Optional<Integer> auxiliaryType) {
            Objects.requireNonNull(auxiliaryType);
            this.fileEntryReader.auxiliaryType = auxiliaryType;
            return this;
        }

        public Builder creationDate(Date creationDate) {
            Objects.requireNonNull(creationDate);
            this.fileEntryReader.creationDate = Optional.of(creationDate);
            return this;
        }

        public Builder creationDate(Optional<Date> creationDate) {
            Objects.requireNonNull(creationDate);
            this.fileEntryReader.creationDate = creationDate;
            return this;
        }

        public Builder lastModificationDate(Date lastModificationDate) {
            Objects.requireNonNull(lastModificationDate);
            this.fileEntryReader.lastModificationDate = Optional.of(lastModificationDate);
            return this;
        }

        public Builder lastModificationDate(Optional<Date> lastModificationDate) {
            Objects.requireNonNull(lastModificationDate);
            this.fileEntryReader.lastModificationDate = lastModificationDate;
            return this;
        }
    }
}

