/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.util.readerwriter;

import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFileEntry;
import com.webcodepro.applecommander.util.readerwriter.FileEntryReader;
import com.webcodepro.applecommander.util.readerwriter.FileEntryWriter;
import java.util.Date;
import java.util.Optional;

public class ProdosFileEntryReaderWriter
implements FileEntryReader,
FileEntryWriter {
    private ProdosFileEntry fileEntry;

    public ProdosFileEntryReaderWriter(ProdosFileEntry fileEntry) {
        this.fileEntry = fileEntry;
    }

    @Override
    public Optional<String> getFilename() {
        return Optional.ofNullable(this.fileEntry.getFilename());
    }

    @Override
    public void setFilename(String filename) {
        this.fileEntry.setFilename(filename);
    }

    @Override
    public Optional<String> getProdosFiletype() {
        return Optional.ofNullable(this.fileEntry.getFiletype());
    }

    @Override
    public void setProdosFiletype(String filetype) {
        this.fileEntry.setFiletype(filetype);
    }

    @Override
    public Optional<Boolean> isLocked() {
        return Optional.of(this.fileEntry.isLocked());
    }

    @Override
    public void setLocked(boolean flag) {
        this.fileEntry.setLocked(flag);
    }

    @Override
    public Optional<byte[]> getFileData() {
        return Optional.ofNullable(this.fileEntry.getFileData());
    }

    @Override
    public void setFileData(byte[] data) {
        try {
            this.fileEntry.setFileData(data);
        }
        catch (DiskFullException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setFileData(byte[] data, byte[] resource) {
        try {
            this.fileEntry.setFileData(data, resource);
            this.fileEntry.setStorageType(5);
        }
        catch (DiskFullException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Optional<Integer> getBinaryAddress() {
        if (this.fileEntry.needsAddress()) {
            return Optional.of(this.fileEntry.getAuxiliaryType());
        }
        return Optional.empty();
    }

    @Override
    public void setBinaryAddress(int address) {
        if (this.fileEntry.needsAddress()) {
            this.fileEntry.setAddress(address);
        }
    }

    @Override
    public Optional<Integer> getBinaryLength() {
        return Optional.of(this.fileEntry.getSize());
    }

    @Override
    public void setBinaryLength(int length) {
    }

    @Override
    public Optional<Integer> getAuxiliaryType() {
        return Optional.of(this.fileEntry.getAuxiliaryType());
    }

    @Override
    public void setAuxiliaryType(int auxType) {
        this.fileEntry.setAuxiliaryType(auxType);
    }

    @Override
    public Optional<Date> getCreationDate() {
        return Optional.ofNullable(this.fileEntry.getCreationDate());
    }

    @Override
    public void setCreationDate(Date date) {
        this.fileEntry.setCreationDate(date);
    }

    @Override
    public Optional<Date> getLastModificationDate() {
        return Optional.ofNullable(this.fileEntry.getLastModificationDate());
    }

    @Override
    public void setLastModificationDate(Date date) {
        this.fileEntry.setLastModificationDate(date);
    }
}

