/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.disassembler.api;

import io.github.applecommander.disassembler.api.Instruction;
import io.github.applecommander.disassembler.api.InstructionSet;
import io.github.applecommander.disassembler.api.Program;
import io.github.applecommander.disassembler.api.SkippedInstruction;
import io.github.applecommander.disassembler.api.mos6502.InstructionSet6502;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ini4j.Ini;
import org.ini4j.Profile;

public class Disassembler {
    private static Ini ini = new Ini();
    private int startAddress;
    private int bytesToSkip;
    private byte[] code;
    private InstructionSet instructionSet;
    private Map<Integer, String> labels = new HashMap<Integer, String>();

    public static Builder with(byte[] code) {
        return new Builder(code);
    }

    public List<Instruction> decode() {
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        Program program = new Program(this.code, this.startAddress);
        while (program.hasMore()) {
            Instruction instruction = null;
            instruction = program.currentOffset() < this.bytesToSkip ? SkippedInstruction.from(program) : this.instructionSet.decode(program);
            instructions.add(instruction);
            boolean between = instruction.getOperandValue() >= this.startAddress && instruction.getOperandValue() < this.startAddress + this.code.length;
            if (!between || !instruction.operandHasAddress()) continue;
            this.labels.computeIfAbsent(instruction.getOperandValue(), addr -> String.format("L%04X", addr));
        }
        for (Instruction instruction : instructions) {
            if (this.labels.containsKey(instruction.getAddress())) {
                instruction.setAddressLabel(this.labels.get(instruction.getAddress()));
            }
            if (!instruction.operandHasAddress() || !this.labels.containsKey(instruction.getOperandValue())) continue;
            instruction.setOperandLabel(this.labels.get(instruction.getOperandValue()));
        }
        return instructions;
    }

    public static Optional<Integer> convert(String value) {
        if (value == null) {
            return Optional.empty();
        }
        if (value.startsWith("$")) {
            return Optional.of(Integer.valueOf(value.substring(1), 16));
        }
        if (value.startsWith("0x") || value.startsWith("0X")) {
            return Optional.of(Integer.valueOf(value.substring(2), 16));
        }
        return Optional.of(Integer.valueOf(value));
    }

    public static Set<String> sections() {
        return ini.keySet();
    }

    static {
        try (InputStream is = Disassembler.class.getResourceAsStream("/addresses.ini");){
            ini.load(is);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class Builder {
        private Set<String> sections = new HashSet<String>();
        private Disassembler disassembler = new Disassembler();

        public Builder(byte[] code) {
            this.disassembler.startAddress = 768;
            this.disassembler.code = code;
            this.disassembler.instructionSet = InstructionSet6502.for6502();
        }

        public List<Instruction> decode() {
            for (String name : this.sections) {
                Profile.Section section = (Profile.Section)ini.get((Object)name);
                if (section == null) {
                    throw new RuntimeException(String.format("Section '%s' not defined.", name));
                }
                for (Map.Entry entry : section.entrySet()) {
                    Optional<Integer> address = Disassembler.convert((String)entry.getValue());
                    if (!address.isPresent()) continue;
                    this.disassembler.labels.putIfAbsent(address.get(), (String)entry.getKey());
                }
            }
            return this.disassembler.decode();
        }

        public Builder startingAddress(int address) {
            this.disassembler.startAddress = address;
            return this;
        }

        public Builder bytesToSkip(int skip) {
            this.disassembler.bytesToSkip = skip;
            return this;
        }

        public Builder use(InstructionSet instructionSet) {
            this.disassembler.instructionSet = instructionSet;
            return this;
        }

        public Builder use6502() {
            this.disassembler.instructionSet = InstructionSet6502.for6502();
            return this;
        }

        public Builder use6502WithIllegalOpcodes() {
            this.disassembler.instructionSet = InstructionSet6502.for6502withIllegalInstructions();
            return this;
        }

        public Builder use65C02() {
            this.disassembler.instructionSet = InstructionSet6502.for65C02();
            return this;
        }

        public Builder section(List<String> names) {
            if (names != null) {
                names.forEach(this.sections::add);
            }
            return this;
        }
    }
}

