/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.disassembler.api;

import java.util.Arrays;
import java.util.Objects;

public class Program {
    static final int ADDRESS_SPACE = 65536;
    private int baseAddress;
    private int offset;
    private byte[] code;

    public Program(byte[] code, int address) {
        Objects.requireNonNull(code);
        this.baseAddress = address;
        this.code = code;
        this.offset = 0;
    }

    public boolean hasMore() {
        return this.offset < this.code.length;
    }

    public byte peek() {
        return this.hasMore() ? this.code[this.offset] : (byte)0;
    }

    public byte[] read(int n) {
        byte[] x = Arrays.copyOfRange(this.code, this.offset, this.offset + n);
        this.offset += n;
        return x;
    }

    public int currentOffset() {
        return this.offset;
    }

    public int currentAddress() {
        return (this.baseAddress + this.offset) % 65536;
    }
}

