/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.disassembler.api;

import io.github.applecommander.disassembler.api.Instruction;
import io.github.applecommander.disassembler.api.Program;
import java.util.Optional;

public class SkippedInstruction
implements Instruction {
    private int address;
    private byte[] code;
    private String addressLabel;

    public static Instruction from(Program program) {
        int currentAddress = program.currentAddress();
        byte[] code = program.read(1);
        return new SkippedInstruction(currentAddress, code);
    }

    SkippedInstruction(int address, byte[] code) {
        this.address = address;
        this.code = code;
    }

    @Override
    public int getAddress() {
        return this.address;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public byte[] getBytes() {
        return this.code;
    }

    @Override
    public Optional<String> getAddressLabel() {
        return Optional.ofNullable(this.addressLabel);
    }

    @Override
    public void setAddressLabel(String label) {
        this.addressLabel = label;
    }

    @Override
    public String getOpcodeMnemonic() {
        return "---";
    }

    @Override
    public boolean operandHasAddress() {
        return false;
    }

    @Override
    public int getOperandValue() {
        return 0;
    }

    @Override
    public void setOperandLabel(String label) {
    }

    @Override
    public String formatOperandWithValue() {
        return this.getOpcodeMnemonic();
    }

    @Override
    public String formatOperandWithLabel() {
        return this.getOpcodeMnemonic();
    }
}

