/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.disassembler.api.mos6502;

public enum AddressMode6502 {
    ACC(1, "%s"),
    ABS(3, "%s %s"),
    ABSX(3, "%s %s,X"),
    ABSY(3, "%s %s,Y"),
    IMM(2, "%s #%s"),
    IMP(1, "%s"),
    IND(2, "%s (%s)"),
    INDX(2, "%s (%s,X)"),
    INDY(2, "%s (%s),Y"),
    REL(2, "%s %s"),
    ZP(2, "%s %s"),
    ZPX(2, "%s %s,X"),
    ZPY(2, "%s %s,Y");

    private int instructionLength;
    private String instructionFormat;
    public static AddressMode6502[] MOS6502;
    public static AddressMode6502[] WDC65C02;

    private AddressMode6502(int instructionLength, String instructionFormat) {
        this.instructionLength = instructionLength;
        this.instructionFormat = instructionFormat;
    }

    public int getInstructionLength() {
        return this.instructionLength;
    }

    public String getInstructionFormat() {
        return this.instructionFormat;
    }

    public boolean isOperandAbsoluteAddress() {
        return this.in(ABS, ABSX, ABSY);
    }

    public boolean isOperandRelativeAddress() {
        return this.in(REL);
    }

    private boolean in(AddressMode6502 ... addressModes) {
        for (AddressMode6502 am : addressModes) {
            if (this != am) continue;
            return true;
        }
        return false;
    }

    static {
        MOS6502 = new AddressMode6502[]{IMP, INDX, IMM, ZPX, ZP, ZP, ZP, ZP, IMP, IMM, ACC, IMM, ABS, ABS, ABS, ABS, REL, INDY, IMM, ZPY, ZPX, ZPX, ZPX, ZPX, IMP, ABSY, IMP, ABSY, ABSX, ABSX, ABSX, ABSX, ABS, INDX, IMM, ZPX, ZP, ZP, ZP, ZP, IMP, IMM, ACC, IMM, ABS, ABS, ABS, ABS, REL, INDY, IMM, ZPY, ZPX, ZPX, ZPX, ZPX, IMP, ABSY, IMP, ABSY, ABSX, ABSX, ABSX, ABSX, IMP, INDX, IMM, ZPX, ZP, ZP, ZP, ZP, IMP, IMM, ACC, IMM, ABS, ABS, ABS, ABS, REL, INDY, IMM, ZPY, ZPX, ZPX, ZPX, ZPX, IMP, ABSY, IMP, ABSY, ABSX, ABSX, ABSX, ABSX, IMP, INDX, IMM, ZPX, ZP, ZP, ZP, ZP, IMP, IMM, ACC, IMM, IND, ABS, ABS, ABS, REL, INDY, IMM, ZPY, ZPX, ZPX, ZPX, ZPX, IMP, ABSY, IMP, ABSY, ABSX, ABSX, ABSX, ABSX, IMM, INDX, IMM, ZPX, ZP, ZP, ZP, ZP, IMP, IMM, IMP, IMM, ABS, ABS, ABS, ABS, REL, INDY, IMM, ZPY, ZPX, ZPX, ZPY, ZPY, IMP, ABSY, IMP, ABSY, ABSX, ABSX, ABSY, ABSY, IMM, INDX, IMM, ZPX, ZP, ZP, ZP, ZP, IMP, IMM, IMP, IMM, ABS, ABS, ABS, ABS, REL, INDY, IMM, ZPY, ZPX, ZPX, ZPY, ZPY, IMP, ABSY, IMP, ABSY, ABSX, ABSX, ABSY, ABSY, IMM, INDX, IMM, ZPX, ZP, ZP, ZP, ZP, IMP, IMM, IMP, IMM, ABS, ABS, ABS, ABS, REL, INDY, IMM, ZPY, ZPX, ZPX, ZPX, ZPX, IMP, ABSY, IMP, ABSY, ABSX, ABSX, ABSX, ABSX, IMM, INDX, IMM, ZPX, ZP, ZP, ZP, ZP, IMP, IMM, IMP, IMM, ABS, ABS, ABS, ABS, REL, INDY, IMM, ZPY, ZPX, ZPX, ZPX, ZPX, IMP, ABSY, IMP, ABSY, ABSX, ABSX, ABSX, ABSX};
        WDC65C02 = new AddressMode6502[]{IMP, INDX, IMM, ZPX, ZP, ZP, ZP, ZP, IMP, IMM, ACC, IMM, ABS, ABS, ABS, ABS, REL, INDY, ZP, ZPY, ZP, ZPX, ZPX, ZPX, IMP, ABSY, ACC, ABSY, ABS, ABSX, ABSX, ABSX, ABS, INDX, IMM, ZPX, ZP, ZP, ZP, ZP, IMP, IMM, ACC, IMM, ABS, ABS, ABS, ABS, REL, INDY, ZP, ZPY, ZPX, ZPX, ZPX, ZPX, IMP, ABSY, ACC, ABSY, ABSX, ABSX, ABSX, ABSX, IMP, INDX, IMM, ZPX, ZP, ZP, ZP, ZP, IMP, IMM, ACC, IMM, ABS, ABS, ABS, ABS, REL, INDY, ZP, ZPY, ZPX, ZPX, ZPX, ZPX, IMP, ABSY, IMP, ABSY, ABSX, ABSX, ABSX, ABSX, IMP, INDX, IMM, ZPX, ZP, ZP, ZP, ZP, IMP, IMM, ACC, IMM, IND, ABS, ABS, ABS, REL, INDY, ZP, ZPY, ZPX, ZPX, ZPX, ZPX, IMP, ABSY, IMP, ABSY, ABSX, ABSX, ABSX, ABSX, REL, INDX, IMM, ZPX, ZP, ZP, ZP, ZP, IMP, IMM, IMP, IMM, ABS, ABS, ABS, ABS, REL, INDY, ZP, ZPY, ZPX, ZPX, ZPY, ZPY, IMP, ABSY, IMP, ABSY, ABS, ABSX, ABSX, ABSY, IMM, INDX, IMM, ZPX, ZP, ZP, ZP, ZP, IMP, IMM, IMP, IMM, ABS, ABS, ABS, ABS, REL, INDY, ZP, ZPY, ZPX, ZPX, ZPY, ZPY, IMP, ABSY, IMP, ABSY, ABSX, ABSX, ABSY, ABSY, IMM, INDX, IMM, ZPX, ZP, ZP, ZP, ZP, IMP, IMM, IMP, IMM, ABS, ABS, ABS, ABS, REL, INDY, ZP, ZPY, ZPX, ZPX, ZPX, ZPX, IMP, ABSY, IMP, ABSY, ABSX, ABSX, ABSX, ABSX, IMM, INDX, IMM, ZPX, ZP, ZP, ZP, ZP, IMP, IMM, IMP, IMM, ABS, ABS, ABS, ABS, REL, INDY, ZP, ZPY, ZPX, ZPX, ZPX, ZPX, IMP, ABSY, IMP, ABSY, ABSX, ABSX, ABSX, ABSX};
    }
}

