/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.disassembler.api.mos6502;

import io.github.applecommander.disassembler.api.Instruction;
import io.github.applecommander.disassembler.api.InstructionSet;
import io.github.applecommander.disassembler.api.Program;
import io.github.applecommander.disassembler.api.mos6502.AddressMode6502;
import io.github.applecommander.disassembler.api.mos6502.Instruction6502;
import io.github.applecommander.disassembler.api.mos6502.Opcode6502;

public class InstructionSet6502
implements InstructionSet {
    private AddressMode6502[] addressModes;
    private Opcode6502[] opcodes;

    public static InstructionSet6502 for6502() {
        return new InstructionSet6502(AddressMode6502.MOS6502, Opcode6502.MOS6502);
    }

    public static InstructionSet6502 for6502withIllegalInstructions() {
        return new InstructionSet6502(AddressMode6502.MOS6502, Opcode6502.MOS6502_WITH_ILLEGAL);
    }

    public static InstructionSet6502 for65C02() {
        return new InstructionSet6502(AddressMode6502.WDC65C02, Opcode6502.WDC65C02);
    }

    private InstructionSet6502(AddressMode6502[] addressModes, Opcode6502[] opcodes) {
        this.addressModes = addressModes;
        this.opcodes = opcodes;
    }

    @Override
    public Instruction decode(Program program) {
        int op = Byte.toUnsignedInt(program.peek());
        AddressMode6502 addressMode = this.addressModes[op];
        Opcode6502 opcode = this.opcodes[op];
        if (this.isInvalidInstruction(opcode, op)) {
            addressMode = AddressMode6502.IMP;
        }
        int currentAddress = program.currentAddress();
        byte[] code = program.read(addressMode.getInstructionLength());
        return new Instruction6502(addressMode, opcode, currentAddress, code);
    }

    public boolean isInvalidInstruction(Opcode6502 opcode, int op) {
        if (opcode == Opcode6502.ZZZ) {
            return true;
        }
        return opcode == Opcode6502.NOP && op != 234;
    }
}

