/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.disassembler.api.sweet16;

public enum AddressModeSWEET16 {
    CON(3, "%s R%X,#%s"),
    ABS(3, "%s R%X,%s"),
    DIR(1, "%s R%X"),
    IND(1, "%s @R%X"),
    BRA(2, "%s %s"),
    IMP(1, "%s");

    private int instructionLength;
    private String instructionFormat;
    public static AddressModeSWEET16[] REGISTER_OPS;
    public static AddressModeSWEET16[] NON_REGISTER_OPS;

    private AddressModeSWEET16(int instructionLength, String instructionFormat) {
        this.instructionLength = instructionLength;
        this.instructionFormat = instructionFormat;
    }

    public int getInstructionLength() {
        return this.instructionLength;
    }

    public String getInstructionFormat() {
        return this.instructionFormat;
    }

    public boolean isOperandAbsoluteAddress() {
        return this.is(ABS);
    }

    public boolean isOperandRelativeAddress() {
        return this.is(BRA);
    }

    public boolean doesOperandRequireRegister() {
        return this.is(CON, ABS, DIR, IND);
    }

    private boolean is(AddressModeSWEET16 ... addressModes) {
        for (AddressModeSWEET16 am : addressModes) {
            if (this != am) continue;
            return true;
        }
        return false;
    }

    static {
        REGISTER_OPS = new AddressModeSWEET16[]{null, CON, DIR, DIR, IND, IND, IND, IND, IND, IND, DIR, DIR, IND, DIR, DIR, DIR};
        NON_REGISTER_OPS = new AddressModeSWEET16[]{IMP, BRA, BRA, BRA, BRA, BRA, BRA, BRA, BRA, BRA, IMP, IMP, BRA, IMP, IMP, IMP};
    }
}

