/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.disassembler.api.sweet16;

import io.github.applecommander.disassembler.api.Instruction;
import io.github.applecommander.disassembler.api.sweet16.AddressModeSWEET16;
import io.github.applecommander.disassembler.api.sweet16.OpcodeSWEET16;
import java.util.Optional;

public class InstructionSWEET16
implements Instruction {
    private AddressModeSWEET16 addressMode;
    private OpcodeSWEET16 opcode;
    private int address;
    private int register;
    private byte[] code;
    private String addressLabel;
    private String operandLabel;

    InstructionSWEET16(AddressModeSWEET16 addressMode, OpcodeSWEET16 opcode, int register, int address, byte[] code) {
        this.addressMode = addressMode;
        this.opcode = opcode;
        this.register = register;
        this.address = address;
        this.code = code;
    }

    @Override
    public int getAddress() {
        return this.address;
    }

    @Override
    public int getLength() {
        return this.addressMode.getInstructionLength();
    }

    @Override
    public byte[] getBytes() {
        return this.code;
    }

    @Override
    public Optional<String> getAddressLabel() {
        return Optional.ofNullable(this.addressLabel);
    }

    @Override
    public void setAddressLabel(String label) {
        this.addressLabel = label;
    }

    @Override
    public String getOpcodeMnemonic() {
        return this.opcode.getMnemonic();
    }

    @Override
    public boolean operandHasAddress() {
        return this.addressMode.isOperandAbsoluteAddress() || this.addressMode.isOperandRelativeAddress();
    }

    @Override
    public int getOperandValue() {
        switch (this.getLength()) {
            case 3: {
                return Byte.toUnsignedInt(this.code[1]) + Byte.toUnsignedInt(this.code[2]) * 256;
            }
            case 2: {
                if (this.addressMode.isOperandRelativeAddress()) {
                    return this.address + 2 + this.code[1] & 0xFFFF;
                }
                return Byte.toUnsignedInt(this.code[1]);
            }
        }
        return 0;
    }

    @Override
    public void setOperandLabel(String label) {
        this.addressLabel = label;
    }

    @Override
    public String formatOperandWithValue() {
        String label = "-";
        if (this.addressMode.isOperandAbsoluteAddress() || this.addressMode.isOperandRelativeAddress() || this.getLength() == 3) {
            label = String.format("$%04X", this.getOperandValue());
        } else if (this.getLength() == 2) {
            label = String.format("$%02X", this.getOperandValue());
        }
        return this.internalFormat(label);
    }

    @Override
    public String formatOperandWithLabel() {
        if (this.operandLabel == null) {
            return this.formatOperandWithValue();
        }
        return this.internalFormat(this.operandLabel);
    }

    String internalFormat(String label) {
        if (this.addressMode.doesOperandRequireRegister()) {
            if (this.getLength() == 1) {
                return String.format(this.addressMode.getInstructionFormat(), this.getOpcodeMnemonic(), this.register);
            }
            return String.format(this.addressMode.getInstructionFormat(), this.getOpcodeMnemonic(), this.register, label);
        }
        if (this.getLength() == 1) {
            return String.format(this.addressMode.getInstructionFormat(), this.getOpcodeMnemonic());
        }
        return String.format(this.addressMode.getInstructionFormat(), this.getOpcodeMnemonic(), label);
    }
}

