/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.disassembler.api.sweet16;

import io.github.applecommander.disassembler.api.Instruction;
import io.github.applecommander.disassembler.api.InstructionSet;
import io.github.applecommander.disassembler.api.Program;
import io.github.applecommander.disassembler.api.sweet16.AddressModeSWEET16;
import io.github.applecommander.disassembler.api.sweet16.InstructionSWEET16;
import io.github.applecommander.disassembler.api.sweet16.OpcodeSWEET16;

public class InstructionSetSWEET16
implements InstructionSet {
    public static InstructionSetSWEET16 forSWEET16() {
        return new InstructionSetSWEET16();
    }

    private InstructionSetSWEET16() {
    }

    @Override
    public Instruction decode(Program program) {
        AddressModeSWEET16 addressMode;
        OpcodeSWEET16 opcode;
        int op = Byte.toUnsignedInt(program.peek());
        int low = op & 0xF;
        int high = (op & 0xF0) >> 4;
        int register = low;
        if (high == 0) {
            opcode = OpcodeSWEET16.NON_REGISTER_OPS[low];
            addressMode = AddressModeSWEET16.NON_REGISTER_OPS[low];
        } else {
            opcode = OpcodeSWEET16.REGISTER_OPS[high];
            addressMode = AddressModeSWEET16.REGISTER_OPS[high];
        }
        if (opcode == OpcodeSWEET16.ZZZ) {
            addressMode = AddressModeSWEET16.IMP;
        }
        int currentAddress = program.currentAddress();
        byte[] code = program.read(addressMode.getInstructionLength());
        return new InstructionSWEET16(addressMode, opcode, register, currentAddress, code);
    }
}

