/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.applesingle;

import io.github.applecommander.applesingle.Entry;
import io.github.applecommander.applesingle.EntryType;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Instant;
import java.util.function.IntSupplier;

public class FileDatesInfo {
    public static final Instant EPOCH_INSTANT = Instant.parse("2000-01-01T00:00:00.00Z");
    public static final int UNKNOWN_DATE = Integer.MIN_VALUE;
    public static final int BYTES = 16;
    int creation;
    int modification;
    int backup;
    int access;

    public static int fromInstant(Instant instant) {
        return (int)(instant.getEpochSecond() - EPOCH_INSTANT.getEpochSecond());
    }

    public static FileDatesInfo fromEntry(Entry entry) {
        ByteBuffer infoData = entry.getBuffer();
        int creation = infoData.getInt();
        int modification = infoData.getInt();
        int backup = infoData.getInt();
        int access = infoData.getInt();
        return new FileDatesInfo(creation, modification, backup, access);
    }

    public FileDatesInfo() {
        int current;
        this.creation = current = FileDatesInfo.fromInstant(Instant.now());
        this.modification = current;
        this.backup = current;
        this.access = current;
    }

    public FileDatesInfo(int creation, int modification, int backup, int access) {
        this.creation = creation;
        this.modification = modification;
        this.backup = backup;
        this.access = access;
    }

    public Entry toEntry() {
        ByteBuffer buf = ByteBuffer.allocate(16).order(ByteOrder.BIG_ENDIAN);
        buf.putInt(this.creation);
        buf.putInt(this.modification);
        buf.putInt(this.backup);
        buf.putInt(this.access);
        return Entry.create(EntryType.FILE_DATES_INFO, buf.array());
    }

    public Instant getCreationInstant() {
        return this.toInstant(this::getCreation);
    }

    public Instant getModificationInstant() {
        return this.toInstant(this::getModification);
    }

    public Instant getBackupInstant() {
        return this.toInstant(this::getBackup);
    }

    public Instant getAccessInstant() {
        return this.toInstant(this::getAccess);
    }

    public Instant toInstant(IntSupplier timeSupplier) {
        return Instant.ofEpochSecond((long)timeSupplier.getAsInt() + EPOCH_INSTANT.getEpochSecond());
    }

    public int getCreation() {
        return this.creation;
    }

    public int getModification() {
        return this.modification;
    }

    public int getBackup() {
        return this.backup;
    }

    public int getAccess() {
        return this.access;
    }
}

