/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jelly.apt.freemarker;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateTransformModel;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import net.sf.jelly.apt.freemarker.FreemarkerTemplateBlock;
import net.sf.jelly.apt.strategies.TemplateStrategyControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FreemarkerTransform<S extends TemplateStrategyControl>
implements TemplateTransformModel {
    private String namespace;

    protected FreemarkerTransform(String namespace) {
        this.namespace = namespace;
    }

    public Writer getWriter(Writer out, Map args) throws TemplateModelException, IOException {
        S strategy = this.newStrategy();
        this.setupStrategy(strategy, args);
        return new FreemarkerTemplateBlock(out, (TemplateStrategyControl)strategy, this.getTransformName());
    }

    protected void setupStrategy(S strategy, Map args) throws TemplateModelException {
        for (Object key : args.keySet()) {
            String property = (String)key;
            Object value = args.get(property);
            value = this.unwrap((TemplateModel)value, property);
            Method method = this.findSetter(property, strategy);
            if (value instanceof String && !method.getParameterTypes()[0].isAssignableFrom(String.class) && (value = this.convertString((String)value, method.getParameterTypes()[0])) == null) {
                throw new TemplateModelException("The '" + this.getTransformName() + "' transform doesn't support the '" + property + "' attribute of type String.");
            }
            try {
                method.invoke(strategy, value);
            }
            catch (IllegalArgumentException e) {
                throw new TemplateModelException("The '" + this.getTransformName() + "' transform doesn't support the '" + property + "' attribute of type " + value.getClass().getSimpleName() + ".");
            }
            catch (Exception e) {
                throw new TemplateModelException(e);
            }
        }
    }

    protected Object convertString(String value, Class toClass) {
        if (toClass == Boolean.TYPE || toClass == Boolean.class) {
            return Boolean.valueOf(value);
        }
        if (toClass == Integer.TYPE || toClass == Integer.class) {
            return Integer.valueOf(value);
        }
        if (toClass == Long.TYPE || toClass == Long.class) {
            return Long.valueOf(value);
        }
        if (Enum.class.isAssignableFrom(toClass)) {
            return Enum.valueOf(toClass, value);
        }
        if (toClass == Short.TYPE || toClass == Short.class) {
            return Short.valueOf(value);
        }
        if (toClass == Double.TYPE || toClass == Double.class) {
            return Double.valueOf(value);
        }
        if (toClass == Float.TYPE || toClass == Float.class) {
            return Float.valueOf(value);
        }
        try {
            Method conversion = toClass.getMethod("fromString", String.class);
            if (Modifier.isStatic(conversion.getModifiers()) && toClass.isAssignableFrom(conversion.getReturnType())) {
                return conversion.invoke(null, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected Object unwrap(TemplateModel value, String property) throws TemplateModelException {
        try {
            return BeansWrapper.getDefaultInstance().unwrap(value);
        }
        catch (TemplateModelException e) {
            throw new TemplateModelException("Unsupported value for parameter '" + property + "' on transform '" + this.getTransformName() + "': " + value.getClass().getName());
        }
    }

    protected Method findSetter(String property, S strategy) throws TemplateModelException {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(strategy.getClass());
            for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
                if (!descriptor.getName().equals(property)) continue;
                return descriptor.getWriteMethod();
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        throw new TemplateModelException("The '" + this.getTransformName() + "' transform doesn't support the '" + property + "' attribute");
    }

    public abstract S newStrategy();

    public String getTransformName() {
        String transformName = this.getClass().getSimpleName();
        return Introspector.decapitalize(transformName.substring(0, transformName.lastIndexOf("Transform")));
    }

    public String getTransformNamespace() {
        return this.namespace;
    }
}

