/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.hibernate3;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.sf.beanlib.CollectionPropertyName;
import net.sf.beanlib.api.BeanPopulatable;
import net.sf.beanlib.hibernate.UnEnhancer;
import net.sf.beanlib.hibernate3.Hibernate3DtoCopier;
import org.apache.commons.lang.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Hibernate3DtoPopulator
implements BeanPopulatable {
    private final Set<Class> entityBeanClassSet;
    private final Set<CollectionPropertyName> collectionPropertyNameSet;
    private Hibernate3DtoCopier applicationBeanCopier;

    Hibernate3DtoPopulator(Set<Class> entityBeanClassSet, Set<CollectionPropertyName> collectionPropertyNameSet) {
        this.entityBeanClassSet = entityBeanClassSet;
        this.collectionPropertyNameSet = collectionPropertyNameSet;
    }

    Hibernate3DtoPopulator(Set<CollectionPropertyName> collectionPropertyNameSet) {
        this.entityBeanClassSet = Collections.emptySet();
        this.collectionPropertyNameSet = collectionPropertyNameSet;
    }

    Hibernate3DtoPopulator() {
        this(null, null);
    }

    Hibernate3DtoPopulator init(Hibernate3DtoCopier applicationBeanCopier) {
        this.applicationBeanCopier = applicationBeanCopier;
        return this;
    }

    public boolean shouldPopulate(String propertyName, Method readerMethod) {
        Class returnType = UnEnhancer.unenhance(readerMethod.getReturnType());
        if (returnType.isPrimitive() || returnType.isArray() && returnType.getComponentType().isPrimitive()) {
            return true;
        }
        String packageName = ClassUtils.getPackageName((Class)returnType);
        if (this.entityBeanClassSet == null) {
            if (this.collectionPropertyNameSet == null) {
                return true;
            }
            return this.checkCollectionProperty(propertyName, readerMethod);
        }
        if (packageName.startsWith("java.")) {
            if (this.collectionPropertyNameSet == null) {
                return true;
            }
            return this.checkCollectionProperty(propertyName, readerMethod);
        }
        boolean goAhead = this.entityBeanClassSet.contains(returnType) || this.applicationBeanCopier.isApplicationClass(returnType);
        Class superClass = returnType;
        while (true) {
            if (goAhead) {
                return true;
            }
            if ((superClass = superClass.getSuperclass()) == null) break;
            goAhead = this.entityBeanClassSet.contains(superClass) || this.applicationBeanCopier.isApplicationClass(superClass);
        }
        return goAhead;
    }

    private boolean checkCollectionProperty(String propertyName, Method readerMethod) {
        Class returnType = UnEnhancer.unenhance(readerMethod.getReturnType());
        if (Collection.class.isAssignableFrom(returnType) || Map.class.isAssignableFrom(returnType)) {
            return this.collectionPropertyNameSet.contains(new CollectionPropertyName(UnEnhancer.unenhance(readerMethod.getDeclaringClass()), propertyName));
        }
        return true;
    }
}

