/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.hibernate3;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.jcip.annotations.ThreadSafe;
import net.sf.beanlib.provider.replicator.CollectionReplicator;
import net.sf.beanlib.spi.BeanTransformerSpi;
import net.sf.beanlib.spi.replicator.CollectionReplicatorSpi;
import net.sf.beanlib.utils.ClassUtils;
import net.sf.cglib.proxy.Enhancer;
import org.hibernate.Hibernate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hibernate3CollectionReplicator
extends CollectionReplicator {
    private static final Factory factory = new Factory();

    public static final Factory getFactory() {
        return factory;
    }

    public static Hibernate3CollectionReplicator newCollectionReplicatable(BeanTransformerSpi beanTransformer) {
        return factory.newCollectionReplicatable(beanTransformer);
    }

    protected Hibernate3CollectionReplicator(BeanTransformerSpi beanTransformer) {
        super(beanTransformer);
    }

    public <V, T> T replicateCollection(Collection<V> from, Class<T> toClass) {
        if (!Hibernate.isInitialized(from)) {
            Hibernate.initialize(from);
        }
        return (T)super.replicateCollection(from, toClass);
    }

    protected Collection<Object> createToCollection(Collection<?> from) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException, InvocationTargetException {
        Class<?> fromClass = from.getClass();
        if (ClassUtils.isJavaPackage(fromClass)) {
            SortedSet fromSortedSet;
            Comparator toComparator;
            if (from instanceof SortedSet && (toComparator = this.createToComparator(fromSortedSet = (SortedSet)from)) != null) {
                return this.createToSortedSetWithComparator(fromSortedSet, toComparator);
            }
            return this.createToInstanceAsCollection(from);
        }
        if (from instanceof SortedSet) {
            SortedSet fromSortedSet = (SortedSet)from;
            Comparator toComparator = this.createToComparator(fromSortedSet);
            if (this.isHibernatePackage(fromClass)) {
                return new TreeSet<Object>(toComparator);
            }
            Constructor<?> constructor = fromClass.getConstructor(Comparator.class);
            Object[] initargs = new Object[]{toComparator};
            return (Collection)constructor.newInstance(initargs);
        }
        if (from instanceof Set) {
            if (this.isHibernatePackage(fromClass)) {
                return new HashSet<Object>();
            }
            return (Collection)fromClass.newInstance();
        }
        if (from instanceof List) {
            if (this.isHibernatePackage(fromClass)) {
                return new ArrayList<Object>(from.size());
            }
            return (Collection)fromClass.newInstance();
        }
        this.log.warn((Object)("Don't know what collection object:" + fromClass + ", so assume List."));
        return new ArrayList<Object>(from.size());
    }

    private boolean isHibernatePackage(Class c) {
        Package p = c.getPackage();
        return p != null && p.getName().startsWith("org.hibernate.");
    }

    protected <T> T createToInstance(Class<T> toClass) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException {
        if (Enhancer.isEnhanced(toClass)) {
            toClass = toClass.getSuperclass();
        }
        return (T)super.createToInstance(toClass);
    }

    @ThreadSafe
    public static class Factory
    implements CollectionReplicatorSpi.Factory {
        private Factory() {
        }

        public Hibernate3CollectionReplicator newCollectionReplicatable(BeanTransformerSpi beanTransformer) {
            return new Hibernate3CollectionReplicator(beanTransformer);
        }
    }
}

